import { Classes, Icon, Popover } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { FC, ReactNode } from 'react'

const content = css`
  padding: 0.5rem;
  max-width: clamp(20rem, 90vw, 40rem);
  white-space: pre-wrap;
`

const target = css`
  display: flex;
`

interface HelpIconProps {
  text: ReactNode
  icon?: ReactNode
}

// TODO: consider switching other Tooltip instances for Popover
const HelpIcon: FC<HelpIconProps> = ({ text, icon }) => (
  <div style={{ cursor: 'pointer' }}>
    {/* Popover respects the light/dark mode, Tooltip reverts it,
     * which creates problems with rendering Tags inside */}
    {/* TODO: clicking on the popover content behaves as
     * clicking on the target, which is confusing in the MilestoneCard */}
    <Popover
      interactionKind='hover'
      content={<div className={content}>{text}</div>}
      targetProps={{ className: target }}
    >
      {icon || <Icon icon='help' className={Classes.TEXT_MUTED} />}
    </Popover>
  </div>
)

export default HelpIcon
