import { useNavigate } from '@/router'
import { Alert, Button } from '@blueprintjs/core'
import type { FC } from 'react'
import { useState } from 'react'

interface ExitButtonProps {
  hideLabel?: boolean
  noConsent?: boolean
}

const ExitButton: FC<ExitButtonProps> = ({ hideLabel, noConsent }) => {
  const nav = useNavigate()
  const [alertOpen, setAlertOpen] = useState(false)

  return (
    <>
      <Button
        active={alertOpen}
        icon='cross-circle'
        intent='danger'
        alignText='left'
        fill
        minimal
        text={!hideLabel && 'Exit'}
        title='Exit'
        onClick={() => (noConsent ? nav('/') : setAlertOpen(true))}
      />
      {!noConsent && (
        <Alert
          isOpen={alertOpen}
          canEscapeKeyCancel
          canOutsideClickCancel
          cancelButtonText='Cancel'
          onCancel={() => setAlertOpen(false)}
          confirmButtonText='Exit'
          icon='cross-circle'
          intent='danger'
          onConfirm={() => nav('/')}
          onClose={() => setAlertOpen(false)}
        >
          <p>Are you sure you want to return to the main menu?</p>
        </Alert>
      )}
    </>
  )
}

export default ExitButton
