import type { ButtonProps } from '@blueprintjs/core'
import { AnchorButton, Button, ButtonGroup, Popover } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { useHost } from '@inject/graphql/connection/host'
import { downloadLogUrl } from '@inject/shared/config'
import type { FC } from 'react'

const content = css`
  padding: 0.5rem;
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
`

interface DownloadLogsButtonProps {
  exerciseId: string
  buttonProps?: ButtonProps
}

const DownloadLogsButton: FC<DownloadLogsButtonProps> = ({
  exerciseId,
  buttonProps,
}) => {
  const host = useHost()

  return (
    <Popover
      content={
        <div className={content}>
          <div>Download logs:</div>
          <ButtonGroup vertical alignText='left'>
            <AnchorButton
              icon='people'
              href={downloadLogUrl(host || '', exerciseId, false)}
              target='_blank'
              rel='noreferrer'
            >
              Standard
            </AnchorButton>
            <AnchorButton
              icon='blocked-person'
              href={downloadLogUrl(host || '', exerciseId, true)}
              target='_blank'
              rel='noreferrer'
            >
              Anonymized
            </AnchorButton>
          </ButtonGroup>
        </div>
      }
      placement='right'
    >
      <Button
        icon='download'
        rightIcon='caret-right'
        text='Download logs'
        {...buttonProps}
      />
    </Popover>
  )
}

export default DownloadLogsButton
