import { Colors } from '@blueprintjs/colors'
import { Tick } from '@blueprintjs/icons'
import { css } from '@emotion/css'
import type { FC, PropsWithChildren } from 'react'

const wrapper = css`
  display: flex;
  gap: 0.5rem;
  justify-content: flex-end;
`

interface DoneProps extends PropsWithChildren {
  done: boolean
  title?: string
}

const Done: FC<DoneProps> = ({ children, done, title }) => (
  <div className={wrapper}>
    {done && <Tick color={Colors.GREEN3} title={title} />}
    {children}
  </div>
)

export default Done
