import { SmallInfoSign } from '@blueprintjs/icons'
import { css, cx } from '@emotion/css'
import type { FC, PropsWithChildren, ReactNode } from 'react'
import HelpIcon from '../HelpIcon'

const wrapper = css`
  display: flex;
  gap: 0.25rem;
`

const justifyCenter = css`
  justify-content: center;
`

const text = css`
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
`

interface DescriptionProps extends PropsWithChildren {
  description: ReactNode
  hideDescription?: boolean
  center?: boolean
}

const Description: FC<DescriptionProps> = ({
  description,
  hideDescription,
  children,
  center,
}) => (
  <div
    className={cx({
      [wrapper]: true,
      [justifyCenter]: center,
    })}
  >
    {children}
    {!hideDescription && (
      <HelpIcon
        icon={<SmallInfoSign />}
        text={<div className={text}>{description}</div>}
      />
    )}
  </div>
)

export default Description
