import { css, cx } from '@emotion/css'
import type { Content } from '@inject/graphql/fragment-types'
import { breakWord } from '@inject/shared/css/textOverflow'
import type { FC } from 'react'
import FileViewRedirectButton from '../FileViewRedirectButton'
import RenderedContent from '../RenderedContent'

const wrapper = css`
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
  flex: 1;
  overflow: auto;
`

const removeFirstAndLastMargin = css`
  & > *:first-child {
    margin-top: 0;
  }

  & > *:last-child {
    margin-bottom: 0;
  }
`

interface ContentComponentProps {
  content: Content
  teamId: string
  exerciseId: string
  inInstructor: boolean
}

const ContentComponent: FC<ContentComponentProps> = ({
  content,
  teamId,
  exerciseId,
  inInstructor,
}) => (
  <div className={wrapper}>
    {content.rendered && (
      <RenderedContent
        className={cx(removeFirstAndLastMargin, breakWord)}
        renderedContent={content.rendered}
        teamId={teamId}
        inInstructor={inInstructor}
      />
    )}
    {content.fileInfo && (
      <FileViewRedirectButton
        teamId={teamId}
        fileInfo={content.fileInfo}
        exerciseId={exerciseId}
      />
    )}
  </div>
)

export default ContentComponent
