/* eslint-disable @typescript-eslint/no-explicit-any */
import { Section, Switch } from '@blueprintjs/core'
import { useReactiveVar, type makeVar } from '@inject/shared/utils/reactive'
import type { FC } from 'react'

const View: FC<{
  variable: ReturnType<typeof makeVar<any>>
  trueValue?: string
  falseValue?: string
}> = ({ variable, trueValue = 'Yes', falseValue = 'No' }) => {
  const reactiveVar = useReactiveVar(variable)
  return (
    <>
      <span>{reactiveVar ? trueValue : falseValue}</span>
      <Switch
        style={{ margin: '0' }}
        checked={reactiveVar}
        onChange={() => variable(!reactiveVar)}
      />
    </>
  )
}

const SwitchSetting: FC<{
  variable: ReturnType<typeof makeVar<any>>
  title: string
  subtitle?: string
  trueValue?: string
  falseValue?: string
}> = ({ variable, title, subtitle, trueValue = 'Yes', falseValue = 'No' }) => (
  <Section
    title={title}
    subtitle={subtitle}
    rightElement={
      <div style={{ display: 'flex', gap: '0.25rem', alignItems: 'center' }}>
        <View
          variable={variable}
          falseValue={falseValue}
          trueValue={trueValue}
        />
      </div>
    }
  />
)

export default SwitchSetting
