import { Button, Section } from '@blueprintjs/core'
import { useAuthIdentity } from '@inject/graphql/auth'
import { useNavigate } from 'react-router-dom'

const GraphiQL = () => {
  const nav = useNavigate()
  const { isSuperuser } = useAuthIdentity()

  return isSuperuser ? (
    <Section
      title='GraphiQL'
      subtitle='Interact with the GraphQL API'
      rightElement={
        <Button icon='open-application' onClick={() => nav('/graphiql')}>
          Open
        </Button>
      }
    />
  ) : (
    <></>
  )
}

export default GraphiQL
