import ExerciseContext from '@/analyst/ExerciseContext'
import { useTypedQuery } from '@inject/graphql/graphql'
import { GetMilestones } from '@inject/graphql/queries'
import notEmpty from '@inject/shared/utils/notEmpty'
import { useContext, useMemo } from 'react'

const useMilestones = () => {
  const { exercise } = useContext(ExerciseContext)

  const [{ data: milestonesData }] = useTypedQuery({
    query: GetMilestones,
    variables: {
      exerciseId: exercise.id,
    },
    context: useMemo(
      () => ({
        suspense: true,
      }),
      []
    ),
  })

  return milestonesData && milestonesData.milestones
    ? milestonesData.milestones.filter(notEmpty)
    : []
}

export default useMilestones
