import type { Team, Tool } from '@inject/graphql/fragment-types'

export interface selectedReducerStateProps {
  team?: Team
  tool?: Tool
}

export interface selectedReducerActionProps {
  type: 'selectTeam' | 'selectTool' | 'resetSelection'
  team?: Team
  tool?: Tool
}

const selectedReducer = (
  state: selectedReducerStateProps,
  action: selectedReducerActionProps
): selectedReducerStateProps => {
  switch (action.type) {
    case 'selectTeam':
      return {
        ...state,
        team: action.team,
      }
    case 'selectTool':
      return {
        ...state,
        tool: action.tool,
      }
    case 'resetSelection':
      return {}
    default:
      throw new Error('unknown action')
  }
}

export default selectedReducer
