import type { Dispatch } from 'react'
import { createContext } from 'react'
import type {
  selectedReducerActionProps,
  selectedReducerStateProps,
} from './selectedReducer'

interface SelectedContextProps {
  selectedReducer: [
    selectedReducerStateProps,
    Dispatch<selectedReducerActionProps>,
  ]
}

const SelectedContext = createContext<SelectedContextProps>({
  selectedReducer: [
    {
      team: undefined,
      tool: undefined,
    },

    () => {},
  ],
})

export default SelectedContext
