import { Colors } from '@blueprintjs/colors'
import { Card, Classes } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { ellipsized } from '@inject/shared/css/textOverflow'
import type { FC } from 'react'

const label = css`
  background-color: ${Colors.LIGHT_GRAY5} !important;
  .${Classes.DARK} & {
    background-color: ${Colors.DARK_GRAY4} !important;
  }

  box-shadow: none !important;

  overflow: hidden;
  padding: 0 0 0 0.5rem;
  display: flex;
  align-items: center;
  flex-grow: 1;
`

interface LabelProps {
  text: string
}

const Label: FC<LabelProps> = ({ text }) => (
  <Card title={text} className={label}>
    <span className={ellipsized}>{text}</span>
  </Card>
)

export default Label
