import type { DefinitionInject } from '@inject/graphql/fragment-types'
import type { FC } from 'react'
import { useContext } from 'react'
import ExerciseContext from '../ExerciseContext'
import useFormatTimestamp from '../useFormatTimestamp'
import { MIN_TO_MS } from '../utilities'

interface CategoryTooltipProps {
  injectGroup: DefinitionInject[]
}

const CategoryTooltip: FC<CategoryTooltipProps> = ({ injectGroup }) => {
  const { exercise } = useContext(ExerciseContext)
  const formatTimestamp = useFormatTimestamp()

  return (
    <>
      {injectGroup.map((inject, i) =>
        i > 1 ? (
          '...'
        ) : (
          <div key={inject.id}>
            {injectGroup.length > 1 && (
              <>
                <em>{`${i + 1}:`}</em>
                <br />
              </>
            )}
            <strong>Name: </strong>
            <span>{inject.name}</span>
            <br />
            <strong>Type: </strong>
            <span>{inject.type}</span>
            <br />
            <strong>Timestamp: </strong>
            <span>
              {formatTimestamp(
                new Date(
                  (exercise.exerciseStart
                    ? new Date(exercise.exerciseStart).getTime()
                    : 0) +
                    (inject.time + inject.delay) * MIN_TO_MS
                ).toISOString()
              )}
            </span>
            <br />
          </div>
        )
      )}
    </>
  )
}

export default CategoryTooltip
