import {
  relativeTime,
  useRelativeTime,
} from '@/clientsettings/vars/relativeTime'
import { Button } from '@blueprintjs/core'
import type { FC } from 'react'

interface TimeSwitchProps {
  hideLabel?: boolean
}

const TimeSwitch: FC<TimeSwitchProps> = ({ hideLabel }) => {
  const relativeTimeVar = useRelativeTime()

  return (
    <Button
      icon='time'
      alignText='left'
      fill
      minimal
      text={
        !hideLabel && `Use ${relativeTimeVar ? 'absolute' : 'relative'} time`
      }
      onClick={() => relativeTime(!relativeTimeVar)}
      style={{ whiteSpace: 'nowrap' }}
      title={`Use ${relativeTimeVar ? 'absolute' : 'relative'} time`}
    />
  )
}

export default TimeSwitch
