import MilestoneDescription from '@/components/Description/MilestoneDescription'
import { Callout, H6 } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { MilestoneState } from '@inject/graphql/fragment-types'
import StyledTag from '@inject/shared/components/StyledTag'
import type { Dispatch, FC } from 'react'
import type { selectedReducerActionProps } from '../Overview/selectedReducer'
import useFormatTimestamp from '../useFormatTimestamp'

export const milestoneCard = (isSelected?: boolean) => css`
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
  flex: 0;
  flex-grow: 0;
  white-space: nowrap;
  text-align: center;
  height: 69;
  cursor: pointer;

  ${isSelected
    ? css`
        box-shadow: 0 0.125rem 0.25rem rgb(17 20 24 / 15%);
      `
    : css`
        &:hover {
          box-shadow: 0 0.125rem 0.25rem rgb(17 20 24 / 10%);
        }

        &:active {
          box-shadow: 0 0.125rem 0.25rem rgb(17 20 24 / 15%);
        }
      `}
`

interface MilestoneCardProps {
  isSelected?: boolean
  milestoneState: MilestoneState
  selectedDispatch: Dispatch<selectedReducerActionProps>
}

const MilestoneCard: FC<MilestoneCardProps> = ({
  isSelected,
  milestoneState,
  selectedDispatch,
}) => {
  const formatTimestamp = useFormatTimestamp()

  const { milestone } = milestoneState

  return (
    <Callout
      className={milestoneCard(isSelected)}
      intent={milestoneState.reached ? 'success' : undefined}
      icon={null}
      onClick={() =>
        selectedDispatch({ type: 'selectMilestones', milestoneState })
      }
    >
      <MilestoneDescription
        milestone={milestone}
        getChildren={displayName => <H6>{displayName}</H6>}
      />
      <StyledTag
        content={
          milestoneState.reached
            ? milestoneState.timestampReached
              ? formatTimestamp(milestoneState.timestampReached)
              : 'Initial'
            : 'Not reached'
        }
        isAchieved={milestoneState.reached ? true : undefined}
      />
    </Callout>
  )
}

export default MilestoneCard
