import { Button, Collapse } from '@blueprintjs/core'
import type { Tool } from '@inject/graphql/fragment-types'
import type { FC } from 'react'
import { useState } from 'react'
import ToolForm from './ToolForm'

interface ToolActionProps {
  tool: Tool
  teamId: string
  disabled?: boolean
  disabledTitle?: string
}

const ToolAction: FC<ToolActionProps> = ({
  tool,
  teamId,
  disabled,
  disabledTitle,
}) => {
  const [open, setOpen] = useState<boolean>(false)
  const newName = tool.name.split('_')[1] ?? tool.name

  return (
    <>
      <Button
        ellipsizeText
        fill
        minimal
        alignText='left'
        icon='sensor'
        text={newName}
        title={newName}
        onClick={() => setOpen(prev => !prev)}
      />
      <Collapse isOpen={open}>
        <ToolForm
          tool={tool}
          teamId={teamId}
          setOpen={setOpen}
          disabled={disabled}
          disabledTitle={disabledTitle}
        />
      </Collapse>
    </>
  )
}

export default ToolAction
