import InstructorQuestionnaireContent from '@/instructor/InstructorQuestionnaire/InstructorQuestionnaireContent'
import type { ActionLog } from '@inject/graphql/fragment-types'
import { type FC } from 'react'
import EmailContent from './EmailContent'
import InjectContent from './InjectContent'
import ToolContent from './ToolContent'
import TraineeQuestionnaireContent from './TraineeQuestionnaireContent'

interface ContentProps {
  actionLog: ActionLog
  exerciseId: string
  teamId: string
  inInstructor: boolean
  onClose?: () => void
}

const Content: FC<ContentProps> = ({
  actionLog,
  exerciseId,
  teamId,
  inInstructor,
  onClose,
}) => {
  switch (actionLog.details.__typename) {
    case 'InjectDetailsType':
      return (
        <InjectContent
          logId={actionLog.id}
          {...actionLog.details}
          teamId={teamId}
          exerciseId={exerciseId}
          inInstructor={inInstructor}
          onClose={onClose}
        />
      )
    case 'CustomInjectDetailsType':
      return (
        <InjectContent
          logId={actionLog.id}
          {...actionLog.details}
          teamId={teamId}
          exerciseId={exerciseId}
          inInstructor={inInstructor}
        />
      )
    case 'ToolDetailsType':
      return (
        <ToolContent
          details={actionLog.details}
          teamId={teamId}
          exerciseId={exerciseId}
          inInstructor={inInstructor}
        />
      )
    case 'QuestionnaireType':
      return inInstructor ? (
        <InstructorQuestionnaireContent
          details={actionLog.details}
          teamId={teamId}
          exerciseId={exerciseId}
        />
      ) : (
        <TraineeQuestionnaireContent
          details={actionLog.details}
          teamId={teamId}
          exerciseId={exerciseId}
          onClose={onClose}
        />
      )
    case 'EmailType':
      return (
        <EmailContent
          details={actionLog.details}
          teamId={teamId}
          exerciseId={exerciseId}
          inInstructor={inInstructor}
        />
      )
    default:
      throw new Error(`unknown actionLog type: ${actionLog.type}`)
  }
}

export default Content
