import ContentComponent from '@/components/ContentComponent'
import { css } from '@emotion/css'
import type { ToolDetails } from '@inject/graphql/fragment-types'
import { breakWord } from '@inject/shared/css/textOverflow'
import type { FC } from 'react'

const wrapper = css`
  overflow: auto;
  display: flex;
  flex-direction: column;
  align-items: flex-start;
  height: 100%;
  width: 100%;
  gap: 0.5rem;
`

const response = css`
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
  width: 100%;
  flex: 1;
  overflow: auto;
`

const emphasized = css`
  font-weight: bold;
`

interface ToolContentProps {
  details: ToolDetails
  teamId: string
  exerciseId: string
  inInstructor: boolean
}

const ToolContent: FC<ToolContentProps> = ({
  details,
  teamId,
  exerciseId,
  inInstructor,
}) => (
  <div className={wrapper}>
    {details.tool.requiresInput && (
      <>
        <div className={emphasized}>argument:</div>
        <div className={breakWord}>{details.argument}</div>
        <div />
      </>
    )}
    <div className={emphasized}>response:</div>
    <div className={response}>
      <ContentComponent
        content={details.content}
        teamId={teamId}
        exerciseId={exerciseId}
        inInstructor={inInstructor}
      />
    </div>
  </div>
)

export default ToolContent
