import ContentComponent from '@/components/ContentComponent'
import { css } from '@emotion/css'
import type { EmailDetails } from '@inject/graphql/fragment-types'
import type { FC } from 'react'

const wrapper = css`
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
`

interface EmailContentProps {
  details: EmailDetails
  teamId: string
  exerciseId: string
  inInstructor: boolean
}

const EmailContent: FC<EmailContentProps> = ({
  details,
  teamId,
  exerciseId,
  inInstructor,
}) => (
  <div className={wrapper}>
    <ContentComponent
      content={details.content}
      teamId={teamId}
      exerciseId={exerciseId}
      inInstructor={inInstructor}
    />
  </div>
)

export default EmailContent
