## HTTPS Deployment

For HTTPS deployment, you need to generate HTTPS certificates. In this configuration these certificates are generated via Certbot by Lets Encrypt.

This can be done via `./cert_script.sh` script which automatically launches Certbot and generates the certificate in the directory of your Docker Compose. To execute the script, you need to write in your email address, where letter of expiry will be sent to you when the certificate needs to be refreshed and domain for which you're generating the certificate. Ex. `./cert_script.sh admin@inject.fi.muni.cz inject.fi.muni.cz`

Please note that by executing this script you're agreeing to Certbot's TOS and Privacy Policy, and your email will be used for essential communication about expiration notices.

After generating the certificates, please ensure that:
- `INJECT_DOMAIN` is setup to your desired hostname in the `.env` file enclosed in the `docker/nginx/https` directory
- `INJECT_SECRET_KEY` is changed to a truly random string of characters of at least 50 characters long
- `01-substitute-env.sh` is executable via `chmod +x 01-substitute-env.sh`.

Then you may execute `docker compose up -d` and your deployment is up and running