import type { CodegenConfig } from '@graphql-codegen/cli'

const config: CodegenConfig = {
  verbose: true,
  noSilentErrors: true,
  ignoreNoDocuments: true, // for better experience with the watcher
  config: {
    scalars: {
      DateTime: 'string',
    },
    skipTypename: true,
    avoidOptionals: true,
    enumsAsTypes: true,
    futureProofEnums: true,
    dedupeOperationSuffix: true,
    useTypeImports: true,
  },
  generates: {
    './generated/schema.json': {
      schema: ['schemas/schema.json', 'schemas/*.graphql'],
      plugins: ['introspection'],
      config: {
        minify: false,
      },
    },
    './generated/schema.remote.json': {
      schema: ['schemas/schema.json'],
      plugins: ['introspection'],
    },
    './generated/schema.graphql': {
      schema: ['schemas/schema.json', 'schemas/*.graphql'],
      plugins: ['schema-ast'],
    },
    './generated/urql/cache-typing.ts': {
      schema: ['schemas/schema.json', 'schemas/*.graphql'],
      plugins: [
        'typescript',
        'typescript-urql-graphcache',
        {
          add: {
            content: '/* eslint-disable */',
          },
        },
      ],
      config: {
        offlineExchange: true,
        nonOptionalTypename: true,
        skipTypename: false,
        useTypeImports: true,
      }
    },
  },
}

export default config
