#!/bin/bash

# WARNING: This script is meant for Docker Compose execution in docker/schema-gen, do not run it directly

# if INJECT_CODEGENENV is not present, stop the script and warn the user
if [ -z "$INJECT_CODEGENENV" ]; then
  echo "Codegen: INJECT_CODEGENENV is not set, please run the script using docker-compose project located in `docker/schema-gen`"
  exit 1
fi

# schemas folder must be present
if [ ! -d "./schemas" ]; then
  echo "Codegen: `schemas` folder not found"
  exit 1
fi

# list out graphql schema files in schemas dir
SCHEMA_FILES=$(find ./schemas -type f -name "*.graphql")
# echo them out
echo "Codegen: Found schema files: $SCHEMA_FILES"

# generate typescript types from graphql schema
yarn exec graphql-codegen --config codegen.ts

echo "Codegen: Done"
 
#The script is pretty straightforward. It checks if the  schemas  and  gql  folders are present. If they are, it runs the codegen script. After the codegen script is done, it moves all the generated files from the  gql  folder to the  generated  folder. 
# The codegen script is a simple script that uses the  graphql-codegen  package to generate typescript types from the graphql schema. 
# Path: codegen/codegen.ts