import { describe, expect, test } from '@jest/globals'
import notEmpty from '@inject/shared/utils/notEmpty'

describe('notEmpty', () => {
  test('should do nothing for non-empty values', () => {
    expect([1, 2, 3].filter(notEmpty)).toEqual([1, 2, 3])
  })
  test('remove empty values', () => {
    expect([1, null, 3].filter(notEmpty)).toEqual([1, 3])
  })
  test('all null should yield empty array', () => {
    expect([null, null, null].filter(notEmpty)).toEqual([])
  })
})
