import { describe, expect, test } from "@jest/globals";
import { sanitizeHtmlCustom } from '@inject/graphql/client/sanitize'

describe('test various edge cases', () => {
    const baseURI = ('http://localhost/exercise_panel')
    test('test if relative tags are allowed', () => {
        const html = '<img src="http://localhost:8000/inject/api/v1/running_exercise/37/e443e6c3-c8c3-4623-af12-a315b93ed8ff?instructor" />'
        expect(sanitizeHtmlCustom(html, baseURI)).toStrictEqual(html)
    })
    test('test if absolute tags are not allowed, aka they point to foreign origins', () => {
        const logSpy = jest.spyOn(global.console, 'error');
        const html = '<img src="https://www.simplilearn.com/ice9/free_resources_article_thumb/what_is_image_Processing.jpg" />'
        expect(sanitizeHtmlCustom(html, baseURI)).toStrictEqual('')
        expect(logSpy).toHaveBeenCalled()
        logSpy.mockRestore()
    })
})