import { describe, expect, test } from '@jest/globals'
import mergeMilestoneState from '@inject/graphql/utils/mergeMilestoneState'

const testMilestone1 = {
  id: '1',
  milestone: {
    id: '1',
    name: 'Test',
    fileNames: '',
    roles: '',
    teamVisible: true,
  },
  reached: false,
  teamIds: [
    '1', '2',
  ],
  timestampReached: new Date().toUTCString(),
}

const testMilestone2 = {
  id: '2',
  milestone: {
    id: '2',
    name: 'Test 2',
    fileNames: '',
    roles: '',
    teamVisible: true,
  },
  reached: false,
  teamIds: [
    '1', '2',
  ],
  timestampReached: new Date().toUTCString(),
}

const testMilestone2Reached = {
  id: '2',
  milestone: {
    id: '2',
    name: 'Test 2',
    fileNames: '',
    roles: '',
    teamVisible: true,
  },
  reached: true,
  teamIds: [
    '1', '2',
  ],
  timestampReached: new Date().toUTCString(),
}

describe('merge milestone state', () => {
  test('empty first array yields second array', () => {
    expect(mergeMilestoneState([], [testMilestone1])).toStrictEqual([testMilestone1])
  })
  test('add existing item to a single array is a no-op (or replace)', () => {
    expect(mergeMilestoneState([testMilestone1], [testMilestone1])).toStrictEqual([testMilestone1])
    expect(mergeMilestoneState([testMilestone2], [testMilestone2Reached])).toStrictEqual([testMilestone2Reached])
  })
  test('add new item to a single array', () => {
    expect(mergeMilestoneState([testMilestone1], [testMilestone2])).toStrictEqual([testMilestone1, testMilestone2])
  })
  test('replace item of set id to an array', () => {
    expect(mergeMilestoneState([testMilestone1, testMilestone2], [testMilestone2Reached])).toStrictEqual([testMilestone1, testMilestone2Reached])
    expect(mergeMilestoneState([testMilestone2, testMilestone1], [testMilestone2Reached])).toStrictEqual([testMilestone2Reached, testMilestone1])
  })
  test('empty arrays yield empty array', () => {
    expect(mergeMilestoneState([], [])).toStrictEqual([])
  })
  test('empty second array yields first array', () => {
    expect(mergeMilestoneState([testMilestone1], [])).toStrictEqual([testMilestone1])
  })
})
