import sys


class Version:
    major: int
    minor: int
    patch: int
    rc: int

    def __init__(self, version: str):
        if len(version) == 0 or version[0] != "v":
            raise Exception(f"Invalid version `{version}` provided")

        parts = version[1:].split("rc")
        if len(parts) > 2:
            raise Exception(f"Invalid version `{version}` provided")

        tmp = parts[0].split(".")
        if len(tmp) != 3:
            raise Exception(f"Invalid version `{version}` provided")

        self.major, self.minor, self.patch = (
            int(tmp[0]),
            int(tmp[1]),
            int(tmp[2]),
        )

        if len(parts) == 2:
            self.rc = int(parts[1])
        else:
            self.rc = 0

        if self.major < 0 or self.minor < 0 or self.patch < 0 or self.rc < 0:
            raise Exception(f"Invalid version `{version}` provided")

    def __str__(self):
        version = f"v{self.major}.{self.minor}.{self.patch}"
        if self.rc > 0:
            version += f"rc{self.rc}"
        return version


if __name__ == "__main__":
    if len(sys.argv) != 3:
        raise Exception("Not enough arguments")

    old_version = Version(sys.argv[1])

    version_type = sys.argv[2]
    if version_type == "patch":
        old_version.rc = 0
        old_version.patch += 1
    elif version_type == "minor":
        old_version.rc = 0
        old_version.patch = 0
        old_version.minor += 1
    elif version_type == "rc":
        old_version.rc += 1
    elif version_type == "major":
        old_version.rc = 0
        old_version.patch = 0
        old_version.minor = 0
        old_version.major += 1
    elif version_type == "major-rc":
        old_version.rc = 1
        old_version.patch = 0
        old_version.minor = 0
        old_version.major += 1
    elif version_type == "release":
        old_version.rc = 0
        old_version.patch = 0
        old_version.minor = 0
    else:
        raise Exception(f"Unknown version type `{version_type}` provided.")

    print(old_version)
