import { createContext, useContext } from 'react'
import type { PopupContextProps } from './typing'

export const PopupContext = createContext<PopupContextProps>({
  showPopup: () => {},
})

export const PopupProvider = PopupContext.Provider
export const PopupConsumer = PopupContext.Consumer
export const usePopupContext = () => useContext(PopupContext)
