import { Classes } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { PropsWithChildren } from 'react'
import { forwardRef } from 'react'

const popover = css`
  background-color: white;
  padding: 0.5rem;
  border-radius: 0.25rem;
  box-shadow: 0 0 0.125rem rgba(0, 0, 0, 0.5);
  max-height: 20rem;
  overflow-y: auto;
  display: flex;
  min-height: 3rem;

  .${Classes.DARK} & {
    background-color: #2f343c;
    box-shadow: 0 0 0.125rem rgba(255, 255, 255, 0.5);
  }
`

const PopoverContainer = forwardRef<HTMLDivElement, PropsWithChildren>(
  ({ children }, ref) => (
    <div className={popover} ref={ref}>
      {children}
    </div>
  )
)

PopoverContainer.displayName = 'PopoverContainer'

export default PopoverContainer
