import type { Intent, ToastProps } from '@blueprintjs/core'

export interface NotificationProps {
  msg: string
  intent: Intent
  timestamp: number
}

export interface OmittedToastProps
  extends Omit<ToastProps, 'onDismiss' | 'message'> {
  message?: string
}

export type NotifyFunction = (
  msg: string,
  toastProps?: OmittedToastProps,
  timestamp?: Date
) => void

export interface NotifyContextProps {
  notify: NotifyFunction
  removeNotify: (timestamp: number) => void
  clearNotify: () => void
}

export type NotificationContextProps = NotificationProps[] | undefined
