import { OverlayToaster } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { createRoot } from 'react-dom/client'

const toast = css`
  max-height: 100vh;
  overflow: hidden !important;
`

const toaster = await OverlayToaster.createAsync(
  /* props */ {
    position: 'bottom',
    className: toast,
  },
  {
    /*
     * Use createRoot() instead of ReactDOM.render(). This can be deleted after
     * a future Blueprint version uses createRoot() for Toasters by default.
     */
    domRenderer: (toaster, containerElement) =>
      createRoot(containerElement as Element).render(toaster),
  }
)

export default toaster
