import { createContext, useContext } from 'react'
import type { NotifyContextProps } from '../typing'

/*
 * note: if this error ever happens,
 * try checking if you're not
 *  - importing notify context from `lib` directory!
 *  - it should be a level higher
 */
export const NotifyContext = createContext<NotifyContextProps>({
  notify: () => {
    console.error('NotifyContext not initialized')
  },
  removeNotify: () => {
    console.error('NotifyContext not initialized')
  },
  clearNotify: () => {
    console.error('NotifyContext not initialized')
  },
})

export const NotifyProvider = NotifyContext.Provider
export const NotifyConsumer = NotifyContext.Consumer
export const useNotifyContext = () => useContext(NotifyContext)
