const READ_RECEIPT = 'read-receipt'

const Keys = {
  // settings
  GRAPHIQL_CONFIRMED: 'graphiql-confirmed',
  DARK_MODE: 'dark-mode',
  NOTIFICATIONS: 'notifications',
  NOTIFICATION_LIMIT: 'notification-limit',
  EXPERIMENTAL_ALLOWED: 'experimental-allowed',
  RELATIVE_TIME: 'relative-time',
  INSTRUCTOR_TEAMS: 'instructor-teams',

  // connection
  HOST: 'host',
  WS_PATH: 'ws-path',

  // read receipt
  getReadReceiptEmailKey: (id: string) => READ_RECEIPT.concat(`:email:${id}`),
  getReadReceiptEmailThreadKey: (id: string) =>
    READ_RECEIPT.concat(`:email-thread:${id}`),
  getReadReceiptActionLogKey: (id: string) =>
    READ_RECEIPT.concat(`:action-log:${id}`),
  getReadReceiptChannelKey: (id: string) =>
    READ_RECEIPT.concat(`:channel:${id}`),

  // email drafts
  getEmailDraftsKey: (teamId: string, instructor: boolean) =>
    `email-drafts:${teamId}${instructor ? '-instructor' : ''}`,

  // other
  HIDE_SIDEBAR: 'hide-sidebar',
  MILESTONES_OPEN: 'milestones-open',
}

export default Keys
