import type { DocRenderer, DocRendererProps } from '@cyntler/react-doc-viewer'
import { css } from '@emotion/css'
import type { PropsWithChildren } from 'react'
import { textFileLoader } from '../loaders'

const wrapped = css`
  white-space: pre-line;
`

const TXTRenderer: DocRenderer = ({
  mainState: { currentDocument },
}: PropsWithChildren<DocRendererProps>) => {
  const text = currentDocument?.fileData?.toString()

  return (
    <div id='txt-renderer'>
      <div className={wrapped}>{text}</div>
    </div>
  )
}

export default TXTRenderer

TXTRenderer.fileTypes = ['txt', 'text/plain']
TXTRenderer.weight = 0
TXTRenderer.fileLoader = textFileLoader
