export const currentProtocol = () =>
  typeof window == 'object' ? window.location.protocol.replace(':', '') : 'http'
export const httpGraphql = (hostAddress: string) =>
  `${currentProtocol()}://${hostAddress}/inject/api/v1/graphql/`
export const httpHello = (hostAddress: string) =>
  `${currentProtocol()}://${hostAddress}/inject/api/v1/version`
export const wsGraphql = (hostAddress: string) =>
  `ws${currentProtocol() === 'https' ? 's' : ''}://${hostAddress}/inject/api/v1/subscription/`
export const uploadDefinitionUrl = (hostAddress: string) =>
  `${currentProtocol()}://${hostAddress}/inject/api/v1/exercise_definition/upload-definition`
export const validateDefinitionUrl = (hostAddress: string) =>
  `${currentProtocol()}://${hostAddress}/inject/api/v1/exercise_definition/validate`
export const downloadLogUrl = (
  hostAddress: string,
  exerciseId: string,
  anonymize: boolean
) =>
  `${currentProtocol()}://${hostAddress}/inject/api/v1/running_exercise/get_exercise_logs/${exerciseId}${
    anonymize ? '?anonymize' : ''
  }`
export const downloadFileUrl = (
  hostAddress: string,
  teamId: string,
  fileId: string,
  instructor: boolean
) =>
  `${currentProtocol()}://${hostAddress}/inject/api/v1/running_exercise/${teamId}/${fileId}${
    instructor ? '?instructor' : ''
  }`
export const uploadFileUrl = (hostAddress: string, teamId: string) =>
  `${currentProtocol()}://${hostAddress}/inject/api/v1/running_exercise/upload/${teamId}/`
export const exportImportUrl = (hostAddress: string) =>
  `${currentProtocol()}://${hostAddress}/inject/api/v1/export_import`
export const uploadUsersUrl = (hostAddress: string) =>
  `${currentProtocol()}://${hostAddress}/inject/api/v1/user/create-users`
