import { Classes, Divider } from '@blueprintjs/core'
import { css, cx } from '@emotion/css'
import type { FC, ReactNode } from 'react'

const injectMessage = css`
  display: flex;
  flex-direction: column;
  overflow-y: auto;
  margin: 1rem;
  padding: 0.5rem;
  /* subtract the margin */
  width: calc(100% - 2rem);

  border: 1px solid rgba(0, 0, 0, 0.2);
  border-radius: 0.5rem;
  .${Classes.DARK} & {
    border-color: rgba(255, 255, 255, 0.2);
  }

  box-shadow: rgba(0, 0, 0, 0.1) 0 0.125rem 0.5rem;
  transition: box-shadow 0.2s ease;
  &:hover {
    box-shadow: rgba(0, 0, 0, 0.3) 0 0.5rem 1rem;
  }
`

const fillHeight = css`
  /* subtract the margin */
  height: calc(100% - 2rem);
`

const headerClass = css`
  display: flex;
  justify-content: space-between;
  align-items: center;
`

const content = css`
  padding: 0.5rem;
  overflow-y: auto;
  flex: 1;
`

const Message: FC<{
  fill?: boolean
  children?: ReactNode
  header?: ReactNode
  className?: string
}> = ({ fill, children, header, className }) => (
  <div
    className={cx({
      [injectMessage]: true,
      [fillHeight]: fill,
      [className || '']: !!className,
    })}
  >
    {header && (
      <>
        <div className={headerClass}>{header}</div>
        <Divider />
      </>
    )}

    <div className={content}>{children}</div>
  </div>
)

export default Message
