import { Colors } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { FC, PropsWithChildren } from 'react'

const div = css`
  background: ${Colors.RED1};
  color: ${Colors.WHITE};
  border-radius: 0.5rem;
  padding: 0.5rem 1rem;
`

const ErrorMessage: FC<PropsWithChildren> = ({ children }) => (
  <div className={div}>{children}</div>
)

export default ErrorMessage
