import { css, cx } from '@emotion/css'
import type { CSSProperties, FC, PropsWithChildren } from 'react'

const divContainer = css`
  width: 100%;
  margin: 0 auto;
  max-width: 60rem;

  @media (max-width: 60rem) {
    padding-left: 1rem;
    padding-right: 1rem;
  }
`

const heighted = css`
  align-self: center;
  justify-self: center;
  flex-grow: 1;
  height: 100%;
  width: 100%;
`

interface ContainerProps extends PropsWithChildren {
  makeFullHeight?: boolean
  style?: CSSProperties
  className?: string
}

const Container: FC<ContainerProps> = ({
  children,
  makeFullHeight,
  style,
  className,
}) => (
  <div
    className={cx(
      {
        [divContainer]: true,
        [heighted]: makeFullHeight,
      },
      className
    )}
    style={style}
  >
    {children}
  </div>
)

export default Container
