import { css } from '@emotion/css'
import type { CSSProperties, FC } from 'react'
import { useMemo } from 'react'

const colorBox = (color: string) => css`
  border-radius: 0.25rem;
  display: inline-block;
  background-color: ${color};
`

interface ColorBoxProps {
  id: number
  style?: CSSProperties
  title?: string
}

// source: https://blueprintjs.com/docs/#core/colors.qualitative-color-schemes
const COLOR_SCHEME = [
  '#29A634',
  '#D1980B',
  '#D33D17',
  '#9D3F9D',
  '#00A396',
  '#DB2C6F',
  '#8EB125',
  '#946638',
  '#7961DB',
]

const ColorBox: FC<ColorBoxProps> = ({ id, style, title }) => {
  const color = useMemo(() => COLOR_SCHEME[id % COLOR_SCHEME.length], [id])

  return <div className={colorBox(color)} style={style} title={title} />
}

export default ColorBox
