import { css, cx } from '@emotion/css'
import type { FC, PropsWithChildren } from 'react'

const cardList = css`
  padding: 1rem;
  display: grid;
  width: 100%;
  gap: 1rem;
  overflow: auto;
  grid-template-columns: repeat(3, 1fr);

  @media (max-width: 60rem) {
    grid-template-columns: 1fr 1fr;
  }

  @media (max-width: 40rem) {
    grid-template-columns: 1fr;
  }
`

interface CardListProps extends PropsWithChildren {
  className?: string
}

const CardList: FC<CardListProps> = ({ children, className }) => (
  <div className={cx(cardList, ...(className ? [className] : []))}>
    {children}
  </div>
)

export default CardList
