import { useGetExerciseChannels } from '../queries/GetExerciseChannels.generated'

const useToolsEnabled = (
  ...params: Parameters<typeof useGetExerciseChannels>
) => {
  const queryResult = useGetExerciseChannels(...params)

  return (
    queryResult.data?.exerciseChannels?.some(
      channel => channel?.type === 'TOOL'
    ) || false
  )
}

export default useToolsEnabled
