import { useGetExerciseChannels } from '../queries/GetExerciseChannels.generated'

const useEmailsEnabled = (
  ...params: Parameters<typeof useGetExerciseChannels>
) => {
  const queryResult = useGetExerciseChannels(...params)

  return (
    queryResult.data?.exerciseChannels?.some(
      channel => channel?.type === 'EMAIL'
    ) || false
  )
}

export default useEmailsEnabled
