import setsEqual from '@inject/shared/utils/setsEqual'
import type { MilestoneState } from '../fragments/MilestoneState.generated'

const milestoneStatesEqual = (state1: MilestoneState, state2: MilestoneState) =>
  state1.milestone.id === state2.milestone.id &&
  setsEqual(new Set(state1.teamIds), new Set(state2.teamIds))

export default milestoneStatesEqual
