/*
 *Merges two arrays of MilestoneState objects, preferring the second array.
 *If an object in the second array is not present in the first, it is added.
 *If an object in the second array is present in the first, it is replaced.
 */

import type { MilestoneState } from '../fragments/MilestoneState.generated'

function mergeMilestoneState(
  arr1: MilestoneState[],
  arr2: MilestoneState[]
): MilestoneState[] {
  return [
    ...arr1.map(v => {
      const needle = arr2.find(y => y.id === v.id)
      if (needle === undefined) {
        return v
      }
      return needle
    }),
    ...arr2.filter(v => !arr1.find(x => x.id === v.id)),
  ]
}

export default mergeMilestoneState
