/* eslint-disable */
//@ts-nocheck
import type { GraphQLResolveInfo, GraphQLScalarType, GraphQLScalarTypeConfig } from 'graphql';
export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
export type MakeEmpty<T extends { [key: string]: unknown }, K extends keyof T> = { [_ in K]?: never };
export type Incremental<T> = T | { [P in keyof T]?: P extends ' $fragmentName' | '__typename' ? T[P] : never };
export type Omit<T, K extends keyof T> = Pick<T, Exclude<keyof T, K>>;
export type RequireFields<T, K extends keyof T> = Omit<T, K> & { [P in K]-?: NonNullable<T[P]> };
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: { input: string; output: string; }
  String: { input: string; output: string; }
  Boolean: { input: boolean; output: boolean; }
  Int: { input: number; output: number; }
  Float: { input: number; output: number; }
  /**
   * The `DateTime` scalar type represents a DateTime
   * value as specified by
   * [iso8601](https://en.wikipedia.org/wiki/ISO_8601).
   */
  DateTime: { input: string; output: string; }
  /**
   * Leverages the internal Python implmeentation of UUID (uuid.UUID) to provide native UUID objects
   * in fields, resolvers and input.
   */
  UUID: { input: any; output: any; }
};

export type ActionLogDetails = CustomInjectDetailsType | EmailType | InjectDetailsType | QuestionnaireType | ToolDetailsType;

export type ActionLogType = {
  channel: DefinitionChannelType;
  details: ActionLogDetails;
  id: Scalars['ID']['output'];
  readReceipt?: Maybe<Scalars['DateTime']['output']>;
  team: TeamType;
  timestamp: Scalars['DateTime']['output'];
  type: LogType;
};

export type ActionLogsSubscription = {
  actionLog?: Maybe<ActionLogType>;
};

export type AddDefinitionAccessMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type AnalyticsActionLogsSubscription = {
  actionLog?: Maybe<ActionLogType>;
};

export type AnalyticsEmailThreadSubscription = {
  emailThread?: Maybe<EmailThreadType>;
};

export type AnalyticsMilestonesSubscription = {
  milestones?: Maybe<Array<Maybe<MilestoneStateType>>>;
};

export type AnswerInput = {
  /** Numeric position of the selected option, 1-based */
  choice: Scalars['Int']['input'];
  questionId: Scalars['ID']['input'];
};

export type AnswerQuestionnaireMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type AssignInstructorsToExercise = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type AssignUsersByTags = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type AssignUsersEqually = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type AssignUsersToTeamMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

/** An enumeration. */
export type AuthGroup =
  | 'ADMIN'
  | 'INSTRUCTOR'
  | 'TRAINEE'
  | '%future added value';

export type ChangeUserDataMutation = {
  user?: Maybe<UserType>;
};

export type ChangeUserInput = {
  active?: InputMaybe<Scalars['Boolean']['input']>;
  group?: InputMaybe<AuthGroup>;
  userId: Scalars['UUID']['input'];
};

export type ChangeUserType = {
  active?: Maybe<Scalars['Boolean']['output']>;
  group?: Maybe<AuthGroup>;
  userId: Scalars['UUID']['output'];
};

export type ChannelReceipt = {
  channelId: Scalars['ID']['output'];
  readReceipt?: Maybe<Scalars['DateTime']['output']>;
  teamId: Scalars['ID']['output'];
};

/** An enumeration. */
export type ChannelType =
  /** Email */
  | 'EMAIL'
  /** Form */
  | 'FORM'
  /** Info */
  | 'INFO'
  /** Tool */
  | 'TOOL'
  | '%future added value';

export type ConfigOverrideInput = {
  customEmailSuffix?: InputMaybe<Scalars['String']['input']>;
  customTeamNames?: InputMaybe<Array<Scalars['String']['input']>>;
  emailBetweenTeams?: InputMaybe<Scalars['Boolean']['input']>;
  exerciseDuration?: InputMaybe<Scalars['Int']['input']>;
  showExerciseTime?: InputMaybe<Scalars['Boolean']['input']>;
};

export type ConfigOverrideType = {
  customEmailSuffix?: Maybe<Scalars['String']['output']>;
  customTeamNames?: Maybe<Array<Scalars['String']['output']>>;
  emailBetweenTeams?: Maybe<Scalars['Boolean']['output']>;
  exerciseDuration?: Maybe<Scalars['Int']['output']>;
  showExerciseTime?: Maybe<Scalars['Boolean']['output']>;
};

export type ContentType = {
  fileInfo?: Maybe<FileInfoType>;
  id: Scalars['ID']['output'];
  raw: Scalars['String']['output'];
  rendered: Scalars['String']['output'];
};

export type ControlType = {
  activateMilestone: Scalars['String']['output'];
  deactivateMilestone: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  milestoneCondition: Scalars['String']['output'];
  roles: Scalars['String']['output'];
};

export type CopyUsersAssignment = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type CreateExerciseInput = {
  configOverride?: InputMaybe<ConfigOverrideInput>;
  definitionId: Scalars['ID']['input'];
  name?: InputMaybe<Scalars['String']['input']>;
  teamCount: Scalars['Int']['input'];
};

export type CreateExerciseMutation = {
  exercise?: Maybe<ExerciseType>;
};

export type CreateExerciseType = {
  configOverride?: Maybe<ConfigOverrideType>;
  definitionId: Scalars['ID']['output'];
  name?: Maybe<Scalars['String']['output']>;
  teamCount: Scalars['Int']['output'];
};

export type CreateTagMutation = {
  newTag: TagType;
};

export type CreateThreadMutation = {
  thread?: Maybe<EmailThreadType>;
};

export type CreateUserInput = {
  email: Scalars['String']['input'];
  firstName?: InputMaybe<Scalars['String']['input']>;
  group?: InputMaybe<AuthGroup>;
  lastName?: InputMaybe<Scalars['String']['input']>;
  tags?: Array<Scalars['String']['input']>;
};

export type CreateUserMutation = {
  newUser: RestrictedUser;
};

export type CreateUserType = {
  email: Scalars['String']['output'];
  firstName?: Maybe<Scalars['String']['output']>;
  group?: Maybe<AuthGroup>;
  lastName?: Maybe<Scalars['String']['output']>;
  tags: Array<Scalars['String']['output']>;
};

export type CustomInjectDetailsType = {
  content: ContentType;
  id: Scalars['ID']['output'];
  overlay?: Maybe<OverlayType>;
  user?: Maybe<RestrictedUser>;
};

export type CustomInjectInput = {
  content: Scalars['String']['input'];
  exerciseId: Scalars['ID']['input'];
  fileId?: InputMaybe<Scalars['UUID']['input']>;
  overlay?: InputMaybe<OverlayInput>;
  teamIds: Array<InputMaybe<Scalars['ID']['input']>>;
};

export type CustomInjectType = {
  content: Scalars['String']['output'];
  exerciseId: Scalars['ID']['output'];
  fileId?: Maybe<Scalars['UUID']['output']>;
  overlay?: Maybe<OverlayType>;
  teamIds: Array<Maybe<Scalars['ID']['output']>>;
};

export type DefinitionChannelType = {
  definition: DefinitionType;
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  readReceipt: Array<IsUnreadType>;
  type: ChannelType;
};

export type DefinitionInjectType = {
  delay: Scalars['Int']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  organization: Scalars['String']['output'];
  time: Scalars['Int']['output'];
  type: InjectType;
};

export type DefinitionRoleType = {
  definition: DefinitionType;
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
};

export type DefinitionType = {
  addresses: Array<EmailAddressType>;
  channels: Array<DefinitionChannelType>;
  exercises: Array<ExerciseType>;
  files: Array<FileInfoType>;
  id: Scalars['ID']['output'];
  injects: Array<DefinitionInjectType>;
  learningObjectives: Array<LearningObjectiveType>;
  name: Scalars['String']['output'];
  questionnaires: Array<QuestionnaireType>;
  roles: Array<DefinitionRoleType>;
  tools: Array<ToolType>;
  userSet?: Maybe<Array<Maybe<RestrictedUser>>>;
  version: Scalars['String']['output'];
};

export type DeleteDefinitionMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type DeleteExerciseMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type DeleteTagsMutation = {
  operationDone: Scalars['Boolean']['output'];
};

export type DeleteUsersMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type EmailAddressType = {
  address: Scalars['String']['output'];
  control: ControlType;
  definition?: Maybe<ExerciseDefinitionType>;
  description: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  organization: Scalars['String']['output'];
  teamVisible: Scalars['Boolean']['output'];
  templates: Array<EmailTemplateType>;
};

export type EmailDraftInput = {
  activateMilestone?: InputMaybe<Scalars['String']['input']>;
  content?: InputMaybe<Scalars['String']['input']>;
  deactivateMilestone?: InputMaybe<Scalars['String']['input']>;
  emailThreadId?: InputMaybe<Scalars['String']['input']>;
  fileId?: InputMaybe<Scalars['UUID']['input']>;
  instructor: Scalars['Boolean']['input'];
  selectedContacts?: InputMaybe<Array<InputMaybe<Scalars['String']['input']>>>;
  senderAddress?: InputMaybe<Scalars['String']['input']>;
  subject?: InputMaybe<Scalars['String']['input']>;
  teamId: Scalars['String']['input'];
  templateId?: InputMaybe<Scalars['String']['input']>;
};

export type EmailDraftType = {
  activateMilestone?: Maybe<Scalars['String']['output']>;
  content?: Maybe<Scalars['String']['output']>;
  deactivateMilestone?: Maybe<Scalars['String']['output']>;
  emailThreadId?: Maybe<Scalars['String']['output']>;
  fileId?: Maybe<Scalars['UUID']['output']>;
  instructor: Scalars['Boolean']['output'];
  selectedContacts?: Maybe<Array<Maybe<Scalars['String']['output']>>>;
  senderAddress?: Maybe<Scalars['String']['output']>;
  subject?: Maybe<Scalars['String']['output']>;
  teamId: Scalars['String']['output'];
  templateId?: Maybe<Scalars['String']['output']>;
};

export type EmailParticipantType = {
  address: Scalars['String']['output'];
  definitionAddress?: Maybe<EmailAddressType>;
  emails: Array<EmailType>;
  exercise: ExerciseType;
  id: Scalars['ID']['output'];
  team?: Maybe<TeamType>;
  threads: Array<EmailThreadType>;
};

export type EmailReceipt = {
  emailId: Scalars['ID']['output'];
  readReceipt?: Maybe<Scalars['DateTime']['output']>;
};

export type EmailTemplateType = {
  content: ContentType;
  context: Scalars['String']['output'];
  control: ControlType;
  id: Scalars['ID']['output'];
  sender?: Maybe<Scalars['String']['output']>;
};

export type EmailThreadSubscription = {
  emailThread?: Maybe<EmailThreadType>;
};

export type EmailThreadType = {
  emails: Array<EmailType>;
  exercise: ExerciseType;
  id: Scalars['ID']['output'];
  lastEmail?: Maybe<EmailType>;
  participants: Array<EmailParticipantType>;
  readReceipt: Array<IsUnreadType>;
  subject: Scalars['String']['output'];
  timestamp: Scalars['DateTime']['output'];
};

export type EmailType = {
  content: ContentType;
  id: Scalars['ID']['output'];
  overlay?: Maybe<OverlayType>;
  readReceipt?: Maybe<Scalars['DateTime']['output']>;
  sender: EmailParticipantType;
  thread: EmailThreadType;
  timestamp: Scalars['DateTime']['output'];
  user?: Maybe<RestrictedUser>;
};

export type ExerciseDefinitionType = {
  id?: Maybe<Scalars['Int']['output']>;
  name?: Maybe<Scalars['String']['output']>;
};

/** An enumeration. */
export type ExerciseEventTypeEnum =
  | 'CREATE'
  | 'DELETE'
  | 'MODIFY'
  | '%future added value';

export type ExerciseLoopRunningSubscription = {
  exerciseLoopRunning?: Maybe<Scalars['Boolean']['output']>;
};

export type ExerciseType = {
  definition?: Maybe<ExerciseDefinitionType>;
  elapsedS: Scalars['Int']['output'];
  emailParticipants: Array<EmailParticipantType>;
  exerciseStart?: Maybe<Scalars['DateTime']['output']>;
  finished: Scalars['Boolean']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  running: Scalars['Boolean']['output'];
  teams: Array<TeamType>;
  threads: Array<EmailThreadType>;
  userSet?: Maybe<Array<Maybe<RestrictedUser>>>;
  uuid: Scalars['UUID']['output'];
};

export type ExercisesSubscription = {
  eventType?: Maybe<ExerciseEventTypeEnum>;
  exercise?: Maybe<ExerciseType>;
};

export type ExtendedToolType = {
  defaultResponse: Scalars['String']['output'];
  definition?: Maybe<ExerciseDefinitionType>;
  hint: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  responses: Array<ToolResponseType>;
  roles: Scalars['String']['output'];
  tooltipDescription: Scalars['String']['output'];
};

export type FileInfoType = {
  definition?: Maybe<DefinitionType>;
  fileName: Scalars['String']['output'];
  id: Scalars['UUID']['output'];
};

export type FilterUsersInput = {
  active?: InputMaybe<Scalars['Boolean']['input']>;
  firstName?: InputMaybe<Scalars['String']['input']>;
  groups?: InputMaybe<Array<InputMaybe<AuthGroup>>>;
  imported?: InputMaybe<Scalars['Boolean']['input']>;
  lastName?: InputMaybe<Scalars['String']['input']>;
  limit?: InputMaybe<Scalars['Int']['input']>;
  skip?: InputMaybe<Scalars['Int']['input']>;
  tags?: InputMaybe<Array<InputMaybe<Scalars['String']['input']>>>;
  username?: InputMaybe<Scalars['String']['input']>;
};

export type FilterUsersType = {
  active?: Maybe<Scalars['Boolean']['output']>;
  firstName?: Maybe<Scalars['String']['output']>;
  groups?: Maybe<Array<Maybe<AuthGroup>>>;
  imported?: Maybe<Scalars['Boolean']['output']>;
  lastName?: Maybe<Scalars['String']['output']>;
  limit?: Maybe<Scalars['Int']['output']>;
  skip?: Maybe<Scalars['Int']['output']>;
  tags?: Maybe<Array<Maybe<Scalars['String']['output']>>>;
  username?: Maybe<Scalars['String']['output']>;
};

export type GrapheneConfig = {
  customEmailSuffix?: Maybe<Scalars['String']['output']>;
  emailBetweenTeams?: Maybe<Scalars['Boolean']['output']>;
  enableRoles?: Maybe<Scalars['Boolean']['output']>;
  exerciseDuration?: Maybe<Scalars['Int']['output']>;
  showExerciseTime?: Maybe<Scalars['Boolean']['output']>;
};

export type InjectDetailsType = {
  content: ContentType;
  id: Scalars['ID']['output'];
  inject: DefinitionInjectType;
  overlay?: Maybe<OverlayType>;
};

/** An enumeration. */
export type InjectType =
  /** Email */
  | 'EMAIL'
  /** Form */
  | 'FORM'
  /** Info */
  | 'INFO'
  /** Tool */
  | 'TOOL'
  | '%future added value';

export type IsUnreadType = {
  isUnread?: Maybe<Scalars['Boolean']['output']>;
  teamId: Scalars['ID']['output'];
};

export type LearningActivityType = {
  id: Scalars['ID']['output'];
  milestones: Array<MilestoneType>;
  name: Scalars['String']['output'];
  objective: LearningObjectiveType;
  tags: Scalars['String']['output'];
};

export type LearningObjectiveType = {
  activities: Array<LearningActivityType>;
  definition: DefinitionType;
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  tags: Scalars['String']['output'];
};

/** An enumeration. */
export type LogType =
  | 'CUSTOM_INJECT'
  | 'EMAIL'
  | 'FORM'
  | 'INJECT'
  | 'TOOL'
  | '%future added value';

export type LoginMutation = {
  user?: Maybe<UserType>;
};

export type LogoutMutation = {
  loggedOut?: Maybe<Scalars['Boolean']['output']>;
};

export type MilestoneStateType = {
  activity?: Maybe<TeamLearningActivityType>;
  id: Scalars['ID']['output'];
  milestone: MilestoneType;
  reached: Scalars['Boolean']['output'];
  teamIds?: Maybe<Array<Maybe<Scalars['ID']['output']>>>;
  timestampReached?: Maybe<Scalars['DateTime']['output']>;
};

export type MilestoneType = {
  activity?: Maybe<LearningActivityType>;
  fileNames: Scalars['String']['output'];
  final: Scalars['Boolean']['output'];
  id: Scalars['ID']['output'];
  initialState: Scalars['Boolean']['output'];
  name: Scalars['String']['output'];
  roles: Scalars['String']['output'];
  teamVisible: Scalars['Boolean']['output'];
};

export type MilestonesSubscription = {
  milestones?: Maybe<Array<Maybe<MilestoneStateType>>>;
};

export type ModifyMilestoneMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type MoveExerciseTimeMutation = {
  exercise?: Maybe<ExerciseType>;
};

export type Mutation = {
  /** Mutation for granting access to the specific definition */
  addDefinitionAccess?: Maybe<AddDefinitionAccessMutation>;
  /** Mutation for answering questionnaires */
  answerQuestionnaire?: Maybe<AnswerQuestionnaireMutation>;
  /** Mutation for assigning instructors (users) to the exercise */
  assignInstructorsToExercise?: Maybe<AssignInstructorsToExercise>;
  /** Mutation for assigning users to the teams by tags */
  assignUsersByTags?: Maybe<AssignUsersByTags>;
  /** Mutation for assigning users to the exercise equally if possible */
  assignUsersEqually?: Maybe<AssignUsersEqually>;
  /** Mutation for assigning users to the specific team of the exercise */
  assignUsersToTeam?: Maybe<AssignUsersToTeamMutation>;
  /** Mutation for changing user data */
  changeUserData?: Maybe<ChangeUserDataMutation>;
  /** Mutation for copying users assignments from one exercise to another */
  copyUsersAssignment?: Maybe<CopyUsersAssignment>;
  /** Mutation that creates a new exercise with given definition by its id */
  createExercise?: Maybe<CreateExerciseMutation>;
  /** Mutation for creating a tag */
  createTag?: Maybe<CreateTagMutation>;
  /** Mutation for creating a new thread */
  createThread?: Maybe<CreateThreadMutation>;
  /** Mutation for creating a user */
  createUser?: Maybe<CreateUserMutation>;
  /** Mutation that deletes a definition of given id */
  deleteDefinition?: Maybe<DeleteDefinitionMutation>;
  deleteEmailDraft?: Maybe<MutationResult>;
  /** Mutation that deletes an exercise of given id */
  deleteExercise?: Maybe<DeleteExerciseMutation>;
  /** Mutation for deleting a tag */
  deleteTags?: Maybe<DeleteTagsMutation>;
  /** Mutation for deleting users */
  deleteUsers?: Maybe<DeleteUsersMutation>;
  /** Mutation for logging in an user */
  login?: Maybe<LoginMutation>;
  /** Mutation for logging out an user */
  logout?: Maybe<LogoutMutation>;
  /** Mutation for instructors to modify a team's milestone state */
  modifyMilestone?: Maybe<ModifyMilestoneMutation>;
  /** Mutation for moving the in-exercise time by the specified amount of seconds */
  moveTime?: Maybe<MoveExerciseTimeMutation>;
  /** Mutation for changing a user's password */
  passwordChange?: Maybe<PasswordChange>;
  /** Mutation for re-generating credentials for users */
  regenerateCredentials?: Maybe<RegenerateCredentialsMutation>;
  /** Mutation for removing access of instructors (users) to the definition */
  removeDefinitionAccess?: Maybe<RemoveDefinitionAccessMutation>;
  /** Mutation for removing instructors (users) from the exercise */
  removeInstructorsFromExercise?: Maybe<RemoveInstructorsFromExerciseMutation>;
  /** Mutation for removing users from the specific team of the exercise */
  removeUsersFromTeam?: Maybe<RemoveUsersFromTeamMutation>;
  /** Mutation for sending custom injects */
  sendCustomInject?: Maybe<SendCustomInjectMutation>;
  /** Mutation for sending an email */
  sendEmail?: Maybe<SendEmailMutation>;
  setEmailDraft?: Maybe<EmailDraftType>;
  setIsUnreadChannel?: Maybe<MutationResult>;
  setIsUnreadEmailThread?: Maybe<MutationResult>;
  /** Mutation for starting the specified exercise */
  startExercise?: Maybe<StartExerciseMutation>;
  /** Mutation that stops an exercise of given id */
  stopExercise?: Maybe<StopExerciseMutation>;
  /** Mutation for updating a tag */
  updateTag?: Maybe<UpdateTagMutation>;
  /** Mutation for changing tag assignments */
  updateTagAssignments?: Maybe<UpdateTagAssignmentsMutation>;
  /** Mutation for performing a tool action */
  useTool?: Maybe<UseToolMutation>;
  writeReadReceipt?: Maybe<ReadReceiptType>;
  writeReadReceiptEmail?: Maybe<EmailReceipt>;
};


export type MutationAddDefinitionAccessArgs = {
  definitionId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationAnswerQuestionnaireArgs = {
  questInput: QuestionnaireInput;
};


export type MutationAssignInstructorsToExerciseArgs = {
  exerciseId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationAssignUsersByTagsArgs = {
  exerciseId: Scalars['ID']['input'];
  tagPrefix: Scalars['String']['input'];
  userIds: Array<Scalars['ID']['input']>;
};


export type MutationAssignUsersEquallyArgs = {
  exerciseId: Scalars['ID']['input'];
  userIds: Array<Scalars['ID']['input']>;
};


export type MutationAssignUsersToTeamArgs = {
  teamId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationChangeUserDataArgs = {
  changeUserInput: ChangeUserInput;
};


export type MutationCopyUsersAssignmentArgs = {
  fromExerciseId: Scalars['ID']['input'];
  toExerciseId: Scalars['ID']['input'];
};


export type MutationCreateExerciseArgs = {
  createExerciseInput: CreateExerciseInput;
};


export type MutationCreateTagArgs = {
  name: Scalars['String']['input'];
};


export type MutationCreateThreadArgs = {
  exerciseId: Scalars['ID']['input'];
  participantAddresses: Array<InputMaybe<Scalars['String']['input']>>;
  subject: Scalars['String']['input'];
};


export type MutationCreateUserArgs = {
  createUserInput: CreateUserInput;
};


export type MutationDeleteDefinitionArgs = {
  definitionId: Scalars['ID']['input'];
};


export type MutationDeleteEmailDraftArgs = {
  emailThreadId?: InputMaybe<Scalars['ID']['input']>;
  instructor: Scalars['Boolean']['input'];
  teamId: Scalars['ID']['input'];
};


export type MutationDeleteExerciseArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type MutationDeleteTagsArgs = {
  force?: InputMaybe<Scalars['Boolean']['input']>;
  tagIds: Array<Scalars['ID']['input']>;
};


export type MutationDeleteUsersArgs = {
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationLoginArgs = {
  password: Scalars['String']['input'];
  username: Scalars['String']['input'];
};


export type MutationModifyMilestoneArgs = {
  activate?: InputMaybe<Scalars['Boolean']['input']>;
  milestone: Scalars['String']['input'];
  teamId: Scalars['ID']['input'];
};


export type MutationMoveTimeArgs = {
  exerciseId: Scalars['ID']['input'];
  timeDiff: Scalars['Int']['input'];
};


export type MutationPasswordChangeArgs = {
  newPassword: Scalars['String']['input'];
  newPasswordRepeat: Scalars['String']['input'];
  oldPassword: Scalars['String']['input'];
};


export type MutationRegenerateCredentialsArgs = {
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationRemoveDefinitionAccessArgs = {
  definitionId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationRemoveInstructorsFromExerciseArgs = {
  exerciseId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationRemoveUsersFromTeamArgs = {
  teamId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationSendCustomInjectArgs = {
  customInjectInput: CustomInjectInput;
};


export type MutationSendEmailArgs = {
  sendEmailInput: SendEmailInput;
};


export type MutationSetEmailDraftArgs = {
  emailDraft: EmailDraftInput;
};


export type MutationSetIsUnreadChannelArgs = {
  channelId: Scalars['ID']['input'];
  isUnread: Scalars['Boolean']['input'];
  teamId: Scalars['ID']['input'];
};


export type MutationSetIsUnreadEmailThreadArgs = {
  isUnread: Scalars['Boolean']['input'];
  teamId: Scalars['ID']['input'];
  threadId: Scalars['ID']['input'];
};


export type MutationStartExerciseArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type MutationStopExerciseArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type MutationUpdateTagArgs = {
  newName: Scalars['String']['input'];
  tagId: Scalars['ID']['input'];
};


export type MutationUpdateTagAssignmentsArgs = {
  updateTagAssignmentsInput: UpdateTagAssignmentsInput;
};


export type MutationUseToolArgs = {
  useToolInput: UseToolInput;
};


export type MutationWriteReadReceiptArgs = {
  actionLogId: Scalars['ID']['input'];
};


export type MutationWriteReadReceiptEmailArgs = {
  emailId: Scalars['ID']['input'];
};

export type MutationResult = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type OverlayInput = {
  duration: Scalars['Int']['input'];
};

export type OverlayType = {
  duration: Scalars['Int']['output'];
  id: Scalars['ID']['output'];
};

export type PasswordChange = {
  passwordChanged?: Maybe<Scalars['Boolean']['output']>;
};

export type Query = {
  /** Retrieve action log with given id */
  actionLog?: Maybe<ActionLogType>;
  /** Retrieve all action logs for the specific exercise. Useful for analytics. */
  analyticsActionLogs?: Maybe<Array<Maybe<ActionLogType>>>;
  /** Retrieve all email threads for the specific exercise. Useful for analytics. */
  analyticsEmailThreads?: Maybe<Array<Maybe<EmailThreadType>>>;
  /** Retrieve all milestones for the specific exercise. Useful for analytics. */
  analyticsMilestones?: Maybe<Array<Maybe<MilestoneStateType>>>;
  /** Retrieve a specific channel */
  channel?: Maybe<DefinitionChannelType>;
  /** Retrieve a specific definition */
  definition?: Maybe<DefinitionType>;
  /** Retrieve all definitions */
  definitions?: Maybe<Array<Maybe<DefinitionType>>>;
  /** Retrieve the instructor email addresses from the specified email thread */
  emailAddresses?: Maybe<Array<Maybe<Scalars['String']['output']>>>;
  /** Retrieve the specific email participant */
  emailContact?: Maybe<EmailParticipantType>;
  /** Retrieve all email contacts for the running exercise */
  emailContacts?: Maybe<Array<Maybe<EmailParticipantType>>>;
  /** Retrieve all email templates for the specified exercise and email addresses */
  emailTemplates?: Maybe<Array<Maybe<EmailTemplateType>>>;
  /** Retrieve the specific email thread */
  emailThread?: Maybe<EmailThreadType>;
  /** Retrieve all email threads for the specific team */
  emailThreads?: Maybe<Array<Maybe<EmailThreadType>>>;
  /** Retrieve all channels for an exercise */
  exerciseChannels?: Maybe<Array<Maybe<DefinitionChannelType>>>;
  /** Retrieve the config for the current running exercise */
  exerciseConfig?: Maybe<GrapheneConfig>;
  /** Retrieve an exercise with matching id */
  exerciseId?: Maybe<ExerciseType>;
  /** Retrieve the state of the exercise loop for the specific exercise */
  exerciseLoopRunning?: Maybe<Scalars['Boolean']['output']>;
  /** Retrieve all questionnaire states for this exercise */
  exerciseQuestionnaires?: Maybe<Array<Maybe<TeamQuestionnaireStateType>>>;
  /** Retrieve the amount of time left in the running exercise in seconds */
  exerciseTimeLeft?: Maybe<Scalars['Int']['output']>;
  /** Retrieve all tools for the specific exercise. Useful for analytics. */
  exerciseTools?: Maybe<Array<Maybe<ToolType>>>;
  /** Retrieve all exercises with optional parameters */
  exercises?: Maybe<Array<Maybe<ExerciseType>>>;
  /** Retrieve all tools available to the specific team including all possible responses */
  extendedTeamTools?: Maybe<Array<Maybe<ExtendedToolType>>>;
  /** Retrieve a specific file info */
  fileInfo?: Maybe<FileInfoType>;
  getEmailDraft?: Maybe<EmailDraftType>;
  getEmailDrafts?: Maybe<Array<Maybe<EmailDraftType>>>;
  /** Retrieve all automatic injects */
  injects?: Maybe<Array<Maybe<DefinitionInjectType>>>;
  /** Retrieve all learning objectives for an exercise */
  learningObjectives?: Maybe<Array<Maybe<LearningObjectiveType>>>;
  /** Retrieve all milestones */
  milestones?: Maybe<Array<Maybe<MilestoneType>>>;
  /** Retrieve the specific questionnaire state for this team */
  questionnaireState?: Maybe<TeamQuestionnaireStateType>;
  /** Retrieve all questionnaires for an exercise */
  questionnaires?: Maybe<Array<Maybe<QuestionnaireType>>>;
  /** Retrieve all tags (for filtering) */
  tags?: Maybe<Array<Maybe<TagType>>>;
  /** Retrieve a specific team */
  team?: Maybe<TeamType>;
  /** Retrieve all action logs for the specific team */
  teamActionLogs?: Maybe<Array<Maybe<ActionLogType>>>;
  /** Retrieve all team action logs for the specific channel */
  teamChannelLogs?: Maybe<Array<Maybe<ActionLogType>>>;
  /** Retrieve the email participant that belongs to the specified team */
  teamEmailParticipant?: Maybe<EmailParticipantType>;
  /** Retrieve the learning objectives for the specific team */
  teamLearningObjectives?: Maybe<Array<Maybe<TeamLearningObjectiveType>>>;
  /** Retrieve a specific milestone state */
  teamMilestone?: Maybe<MilestoneStateType>;
  /** Retrieve all milestones for the specific team filtered by team visibility */
  teamMilestones?: Maybe<Array<Maybe<MilestoneStateType>>>;
  /** Retrieve all questionnaire states for this team */
  teamQuestionnaires?: Maybe<Array<Maybe<TeamQuestionnaireStateType>>>;
  /** Retrieve all team roles for the running exercise */
  teamRoles?: Maybe<Array<Maybe<Scalars['String']['output']>>>;
  /** Retrieve all tools available to the specific team */
  teamTools?: Maybe<Array<Maybe<ToolType>>>;
  /** Retrieve all files uploaded by/to the specified team */
  teamUploadedFiles?: Maybe<Array<Maybe<FileInfoType>>>;
  /** Retrieve the specific email template */
  threadTemplate?: Maybe<EmailTemplateType>;
  /** Retrieve all email templates for the specific thread */
  threadTemplates?: Maybe<Array<Maybe<EmailTemplateType>>>;
  user?: Maybe<UserType>;
  /** Retrieve all users with filtering options */
  users?: Maybe<Array<Maybe<UserType>>>;
  /** Validates if the email address is valid for the specified exercise */
  validateEmailAddress?: Maybe<Scalars['Boolean']['output']>;
  /** Retrieve data of the currently logged-in user of the request */
  whoAmI?: Maybe<UserType>;
};


export type QueryActionLogArgs = {
  logId: Scalars['ID']['input'];
};


export type QueryAnalyticsActionLogsArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryAnalyticsEmailThreadsArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryAnalyticsMilestonesArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryChannelArgs = {
  channelId: Scalars['ID']['input'];
};


export type QueryDefinitionArgs = {
  definitionId: Scalars['ID']['input'];
};


export type QueryEmailAddressesArgs = {
  threadId: Scalars['ID']['input'];
};


export type QueryEmailContactArgs = {
  participantId: Scalars['ID']['input'];
};


export type QueryEmailContactsArgs = {
  visibleOnly?: InputMaybe<Scalars['Boolean']['input']>;
};


export type QueryEmailTemplatesArgs = {
  emailAddresses: Array<InputMaybe<Scalars['String']['input']>>;
  exerciseId: Scalars['ID']['input'];
};


export type QueryEmailThreadArgs = {
  threadId: Scalars['ID']['input'];
};


export type QueryEmailThreadsArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryExerciseChannelsArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExerciseConfigArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExerciseIdArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExerciseLoopRunningArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExerciseQuestionnairesArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExerciseToolsArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExercisesArgs = {
  finished?: InputMaybe<Scalars['Boolean']['input']>;
  limit?: InputMaybe<Scalars['Int']['input']>;
  running?: InputMaybe<Scalars['Boolean']['input']>;
  skip?: InputMaybe<Scalars['Int']['input']>;
};


export type QueryExtendedTeamToolsArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryFileInfoArgs = {
  fileInfoId: Scalars['UUID']['input'];
};


export type QueryGetEmailDraftArgs = {
  emailThreadId?: InputMaybe<Scalars['ID']['input']>;
  instructor: Scalars['Boolean']['input'];
  teamId: Scalars['ID']['input'];
};


export type QueryGetEmailDraftsArgs = {
  instructor: Scalars['Boolean']['input'];
  teamId: Scalars['ID']['input'];
};


export type QueryInjectsArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryLearningObjectivesArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryMilestonesArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryQuestionnaireStateArgs = {
  questionnaireId: Scalars['ID']['input'];
  teamId: Scalars['ID']['input'];
};


export type QueryQuestionnairesArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryTeamArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryTeamActionLogsArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryTeamChannelLogsArgs = {
  channelId: Scalars['ID']['input'];
  teamId: Scalars['ID']['input'];
};


export type QueryTeamEmailParticipantArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryTeamLearningObjectivesArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryTeamMilestoneArgs = {
  milestoneStateId: Scalars['ID']['input'];
};


export type QueryTeamMilestonesArgs = {
  teamId: Scalars['ID']['input'];
  visibleOnly?: InputMaybe<Scalars['Boolean']['input']>;
};


export type QueryTeamQuestionnairesArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryTeamToolsArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryTeamUploadedFilesArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryThreadTemplateArgs = {
  templateId: Scalars['ID']['input'];
};


export type QueryThreadTemplatesArgs = {
  threadId: Scalars['ID']['input'];
};


export type QueryUserArgs = {
  userId?: InputMaybe<Scalars['UUID']['input']>;
};


export type QueryUsersArgs = {
  filterUsersInput?: InputMaybe<FilterUsersInput>;
};


export type QueryValidateEmailAddressArgs = {
  address: Scalars['String']['input'];
  exerciseId: Scalars['ID']['input'];
};

export type QuestionType = {
  content: ContentType;
  control: ControlType;
  correct: Scalars['Int']['output'];
  id: Scalars['ID']['output'];
  labels: Scalars['String']['output'];
  max: Scalars['Int']['output'];
  questionnaire: QuestionnaireType;
};

export type QuestionnaireAnswerType = {
  choice: Scalars['Int']['output'];
  id: Scalars['ID']['output'];
  isCorrect?: Maybe<Scalars['Boolean']['output']>;
  question: QuestionType;
  teamQuestionnaireState: TeamQuestionnaireStateType;
};

export type QuestionnaireInput = {
  answers: Array<InputMaybe<AnswerInput>>;
  questionnaireId: Scalars['ID']['input'];
  teamId: Scalars['ID']['input'];
};

export type QuestionnaireType = {
  control: ControlType;
  definition: DefinitionType;
  id: Scalars['ID']['output'];
  overlay?: Maybe<OverlayType>;
  questions: Array<QuestionType>;
  teamQuestionnaireStates: Array<TeamQuestionnaireStateType>;
  time: Scalars['Int']['output'];
  title: Scalars['String']['output'];
};

export type ReadReceiptType = {
  actionLogId: Scalars['ID']['output'];
  readReceipt?: Maybe<Scalars['DateTime']['output']>;
};

export type RegenerateCredentialsMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type RemoveDefinitionAccessMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type RemoveInstructorsFromExerciseMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type RemoveUsersFromTeamMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type RestrictedExercise = {
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  uuid: Scalars['UUID']['output'];
};

export type RestrictedTeam = {
  emailAddress?: Maybe<EmailParticipantType>;
  exercise: ExerciseType;
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  role: Scalars['String']['output'];
};

export type RestrictedUser = {
  dateJoined: Scalars['DateTime']['output'];
  firstName?: Maybe<Scalars['String']['output']>;
  group?: Maybe<AuthGroup>;
  id: Scalars['UUID']['output'];
  isActive: Scalars['Boolean']['output'];
  isImported: Scalars['Boolean']['output'];
  lastLogin?: Maybe<Scalars['DateTime']['output']>;
  lastName?: Maybe<Scalars['String']['output']>;
  tags: Array<TagType>;
  username: Scalars['String']['output'];
};

export type SendCustomInjectMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type SendEmailInput = {
  activateMilestone?: InputMaybe<Scalars['String']['input']>;
  content?: InputMaybe<Scalars['String']['input']>;
  deactivateMilestone?: InputMaybe<Scalars['String']['input']>;
  fileId?: InputMaybe<Scalars['UUID']['input']>;
  senderAddress: Scalars['String']['input'];
  threadId: Scalars['ID']['input'];
};

export type SendEmailMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type SendEmailType = {
  activateMilestone?: Maybe<Scalars['String']['output']>;
  content?: Maybe<Scalars['String']['output']>;
  deactivateMilestone?: Maybe<Scalars['String']['output']>;
  fileId?: Maybe<Scalars['UUID']['output']>;
  senderAddress: Scalars['String']['output'];
  threadId: Scalars['ID']['output'];
};

export type StartExerciseMutation = {
  exercise?: Maybe<ExerciseType>;
};

/** An enumeration. */
export type Status =
  | 'ANSWERED'
  | 'SENT'
  | 'UNSENT'
  | '%future added value';

export type StopExerciseMutation = {
  exercise?: Maybe<ExerciseType>;
};

export type Subscription = {
  /** Subscription notifies about new action logs for the specific team */
  actionLogs?: Maybe<ActionLogsSubscription>;
  /** Subscription notifies about new action logs for the specific exercise */
  analyticsActionLogsSubscription?: Maybe<AnalyticsActionLogsSubscription>;
  /** Subscription notifies about new email threads and new emails for the specific exercise */
  analyticsEmailThreadSubscription?: Maybe<AnalyticsEmailThreadSubscription>;
  /** Subscription notifies about changes in milestone states */
  analyticsMilestonesSubscription?: Maybe<AnalyticsMilestonesSubscription>;
  /** Subscription notifies about new threads and new emails for the specific team */
  emailThreads?: Maybe<EmailThreadSubscription>;
  /** Subscription notifies about the state of the exercise loop */
  exerciseLoopRunning?: Maybe<ExerciseLoopRunningSubscription>;
  /** Subscription that notifies when exercises were modified */
  exercisesSubscription?: Maybe<ExercisesSubscription>;
  /** Subscription notifies about changes in milestone states */
  milestones?: Maybe<MilestonesSubscription>;
  /** Subscription notifies about changes to the state of a teams questionnaires */
  teamQuestionnaireStateSubscription?: Maybe<TeamQuestionnaireStateSubscription>;
};


export type SubscriptionActionLogsArgs = {
  teamId?: InputMaybe<Scalars['ID']['input']>;
};


export type SubscriptionAnalyticsActionLogsSubscriptionArgs = {
  exerciseId?: InputMaybe<Scalars['ID']['input']>;
};


export type SubscriptionAnalyticsEmailThreadSubscriptionArgs = {
  exerciseId?: InputMaybe<Scalars['ID']['input']>;
};


export type SubscriptionAnalyticsMilestonesSubscriptionArgs = {
  exerciseId?: InputMaybe<Scalars['ID']['input']>;
};


export type SubscriptionEmailThreadsArgs = {
  teamId?: InputMaybe<Scalars['ID']['input']>;
};


export type SubscriptionExerciseLoopRunningArgs = {
  exerciseId?: InputMaybe<Scalars['ID']['input']>;
};


export type SubscriptionMilestonesArgs = {
  teamId: Scalars['ID']['input'];
  visibleOnly?: InputMaybe<Scalars['Boolean']['input']>;
};


export type SubscriptionTeamQuestionnaireStateSubscriptionArgs = {
  teamId: Scalars['ID']['input'];
};

export type TagType = {
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
};

export type TeamLearningActivityType = {
  activity: LearningActivityType;
  id: Scalars['ID']['output'];
  milestoneStates: Array<MilestoneStateType>;
  reached?: Maybe<Scalars['Boolean']['output']>;
  teamObjective: TeamLearningObjectiveType;
};

export type TeamLearningObjectiveType = {
  activities: Array<TeamLearningActivityType>;
  id: Scalars['ID']['output'];
  objective: LearningObjectiveType;
  reached?: Maybe<Scalars['Boolean']['output']>;
};

export type TeamQuestionnaireStateSubscription = {
  teamQuestionnaireState: TeamQuestionnaireStateType;
};

export type TeamQuestionnaireStateType = {
  answers: Array<QuestionnaireAnswerType>;
  id: Scalars['ID']['output'];
  questionnaire: QuestionnaireType;
  status?: Maybe<Status>;
  team: TeamType;
  timestampAnswered?: Maybe<Scalars['DateTime']['output']>;
  timestampSent?: Maybe<Scalars['DateTime']['output']>;
};

export type TeamType = {
  emailAddress?: Maybe<EmailParticipantType>;
  exercise: ExerciseType;
  finishTime?: Maybe<Scalars['DateTime']['output']>;
  id: Scalars['ID']['output'];
  logs: Array<ActionLogType>;
  name: Scalars['String']['output'];
  role: Scalars['String']['output'];
  teamQuestionnaireStates: Array<TeamQuestionnaireStateType>;
  userSet?: Maybe<Array<Maybe<RestrictedUser>>>;
};

export type ToolDetailsType = {
  argument: Scalars['String']['output'];
  content: ContentType;
  id: Scalars['ID']['output'];
  tool: ToolType;
  user?: Maybe<RestrictedUser>;
};

export type ToolResponseType = {
  content: ContentType;
  control: ControlType;
  id: Scalars['ID']['output'];
  param: Scalars['String']['output'];
  regex: Scalars['Boolean']['output'];
  time: Scalars['Int']['output'];
  tool: ExtendedToolType;
};

export type ToolType = {
  defaultResponse: Scalars['String']['output'];
  definition?: Maybe<ExerciseDefinitionType>;
  hint: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  roles: Scalars['String']['output'];
  tooltipDescription: Scalars['String']['output'];
};

export type UpdateTagAssignmentsInput = {
  addTags?: Array<Scalars['ID']['input']>;
  removeTags?: Array<Scalars['ID']['input']>;
  userIds: Array<Scalars['ID']['input']>;
};

export type UpdateTagAssignmentsMutation = {
  operationDone: Scalars['Boolean']['output'];
};

export type UpdateTagAssignmentsType = {
  addTags: Array<Scalars['ID']['output']>;
  removeTags: Array<Scalars['ID']['output']>;
  userIds: Array<Scalars['ID']['output']>;
};

export type UpdateTagMutation = {
  updatedTag: TagType;
};

export type UseToolInput = {
  teamId: Scalars['ID']['input'];
  /** Parameter provided by the trainee. */
  toolArgument: Scalars['String']['input'];
  toolId: Scalars['ID']['input'];
};

export type UseToolMutation = {
  operationDone?: Maybe<Scalars['Boolean']['output']>;
};

export type UseToolType = {
  teamId: Scalars['ID']['output'];
  /** Parameter provided by the trainee. */
  toolArgument: Scalars['String']['output'];
  toolId: Scalars['ID']['output'];
};

export type UserType = {
  dateJoined: Scalars['DateTime']['output'];
  definitions?: Maybe<Array<Maybe<ExerciseDefinitionType>>>;
  exercises?: Maybe<Array<Maybe<RestrictedExercise>>>;
  firstName?: Maybe<Scalars['String']['output']>;
  group?: Maybe<AuthGroup>;
  id: Scalars['UUID']['output'];
  isActive: Scalars['Boolean']['output'];
  isImported: Scalars['Boolean']['output'];
  lastLogin?: Maybe<Scalars['DateTime']['output']>;
  lastName?: Maybe<Scalars['String']['output']>;
  tags: Array<TagType>;
  teams?: Maybe<Array<Maybe<RestrictedTeam>>>;
  username: Scalars['String']['output'];
};

export type WithIndex<TObject> = TObject & Record<string, any>;
export type ResolversObject<TObject> = WithIndex<TObject>;

export type ResolverTypeWrapper<T> = Promise<T> | T;


export type ResolverWithResolve<TResult, TParent, TContext, TArgs> = {
  resolve: ResolverFn<TResult, TParent, TContext, TArgs>;
};
export type Resolver<TResult, TParent = {}, TContext = {}, TArgs = {}> = ResolverFn<TResult, TParent, TContext, TArgs> | ResolverWithResolve<TResult, TParent, TContext, TArgs>;

export type ResolverFn<TResult, TParent, TContext, TArgs> = (
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => Promise<TResult> | TResult;

export type SubscriptionSubscribeFn<TResult, TParent, TContext, TArgs> = (
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => AsyncIterable<TResult> | Promise<AsyncIterable<TResult>>;

export type SubscriptionResolveFn<TResult, TParent, TContext, TArgs> = (
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => TResult | Promise<TResult>;

export interface SubscriptionSubscriberObject<TResult, TKey extends string, TParent, TContext, TArgs> {
  subscribe: SubscriptionSubscribeFn<{ [key in TKey]: TResult }, TParent, TContext, TArgs>;
  resolve?: SubscriptionResolveFn<TResult, { [key in TKey]: TResult }, TContext, TArgs>;
}

export interface SubscriptionResolverObject<TResult, TParent, TContext, TArgs> {
  subscribe: SubscriptionSubscribeFn<any, TParent, TContext, TArgs>;
  resolve: SubscriptionResolveFn<TResult, any, TContext, TArgs>;
}

export type SubscriptionObject<TResult, TKey extends string, TParent, TContext, TArgs> =
  | SubscriptionSubscriberObject<TResult, TKey, TParent, TContext, TArgs>
  | SubscriptionResolverObject<TResult, TParent, TContext, TArgs>;

export type SubscriptionResolver<TResult, TKey extends string, TParent = {}, TContext = {}, TArgs = {}> =
  | ((...args: any[]) => SubscriptionObject<TResult, TKey, TParent, TContext, TArgs>)
  | SubscriptionObject<TResult, TKey, TParent, TContext, TArgs>;

export type TypeResolveFn<TTypes, TParent = {}, TContext = {}> = (
  parent: TParent,
  context: TContext,
  info: GraphQLResolveInfo
) => Maybe<TTypes> | Promise<Maybe<TTypes>>;

export type IsTypeOfResolverFn<T = {}, TContext = {}> = (obj: T, context: TContext, info: GraphQLResolveInfo) => boolean | Promise<boolean>;

export type NextResolverFn<T> = () => Promise<T>;

export type DirectiveResolverFn<TResult = {}, TParent = {}, TContext = {}, TArgs = {}> = (
  next: NextResolverFn<TResult>,
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => TResult | Promise<TResult>;

/** Mapping of union types */
export type ResolversUnionTypes<_RefType extends Record<string, unknown>> = ResolversObject<{
  ActionLogDetails: ( CustomInjectDetailsType & { __typename: 'CustomInjectDetailsType' } ) | ( Omit<EmailType, 'sender'> & { sender: _RefType['EmailParticipantType'] } & { __typename: 'EmailType' } ) | ( InjectDetailsType & { __typename: 'InjectDetailsType' } ) | ( Omit<QuestionnaireType, 'definition' | 'teamQuestionnaireStates'> & { definition: _RefType['DefinitionType'], teamQuestionnaireStates: Array<_RefType['TeamQuestionnaireStateType']> } & { __typename: 'QuestionnaireType' } ) | ( ToolDetailsType & { __typename: 'ToolDetailsType' } );
}>;


/** Mapping between all available schema types and the resolvers types */
export type ResolversTypes = ResolversObject<{
  ActionLogDetails: ResolverTypeWrapper<ResolversUnionTypes<ResolversTypes>['ActionLogDetails']>;
  ActionLogType: ResolverTypeWrapper<Omit<ActionLogType, 'channel' | 'details' | 'team'> & { channel: ResolversTypes['DefinitionChannelType'], details: ResolversTypes['ActionLogDetails'], team: ResolversTypes['TeamType'] }>;
  ActionLogsSubscription: ResolverTypeWrapper<Omit<ActionLogsSubscription, 'actionLog'> & { actionLog?: Maybe<ResolversTypes['ActionLogType']> }>;
  AddDefinitionAccessMutation: ResolverTypeWrapper<AddDefinitionAccessMutation>;
  AnalyticsActionLogsSubscription: ResolverTypeWrapper<Omit<AnalyticsActionLogsSubscription, 'actionLog'> & { actionLog?: Maybe<ResolversTypes['ActionLogType']> }>;
  AnalyticsEmailThreadSubscription: ResolverTypeWrapper<AnalyticsEmailThreadSubscription>;
  AnalyticsMilestonesSubscription: ResolverTypeWrapper<Omit<AnalyticsMilestonesSubscription, 'milestones'> & { milestones?: Maybe<Array<Maybe<ResolversTypes['MilestoneStateType']>>> }>;
  AnswerInput: AnswerInput;
  AnswerQuestionnaireMutation: ResolverTypeWrapper<AnswerQuestionnaireMutation>;
  AssignInstructorsToExercise: ResolverTypeWrapper<AssignInstructorsToExercise>;
  AssignUsersByTags: ResolverTypeWrapper<AssignUsersByTags>;
  AssignUsersEqually: ResolverTypeWrapper<AssignUsersEqually>;
  AssignUsersToTeamMutation: ResolverTypeWrapper<AssignUsersToTeamMutation>;
  AuthGroup: AuthGroup;
  Boolean: ResolverTypeWrapper<Scalars['Boolean']['output']>;
  ChangeUserDataMutation: ResolverTypeWrapper<Omit<ChangeUserDataMutation, 'user'> & { user?: Maybe<ResolversTypes['UserType']> }>;
  ChangeUserInput: ChangeUserInput;
  ChangeUserType: ResolverTypeWrapper<ChangeUserType>;
  ChannelReceipt: ResolverTypeWrapper<ChannelReceipt>;
  ChannelType: ChannelType;
  ConfigOverrideInput: ConfigOverrideInput;
  ConfigOverrideType: ResolverTypeWrapper<ConfigOverrideType>;
  ContentType: ResolverTypeWrapper<ContentType>;
  ControlType: ResolverTypeWrapper<ControlType>;
  CopyUsersAssignment: ResolverTypeWrapper<CopyUsersAssignment>;
  CreateExerciseInput: CreateExerciseInput;
  CreateExerciseMutation: ResolverTypeWrapper<Omit<CreateExerciseMutation, 'exercise'> & { exercise?: Maybe<ResolversTypes['ExerciseType']> }>;
  CreateExerciseType: ResolverTypeWrapper<CreateExerciseType>;
  CreateTagMutation: ResolverTypeWrapper<CreateTagMutation>;
  CreateThreadMutation: ResolverTypeWrapper<CreateThreadMutation>;
  CreateUserInput: CreateUserInput;
  CreateUserMutation: ResolverTypeWrapper<CreateUserMutation>;
  CreateUserType: ResolverTypeWrapper<CreateUserType>;
  CustomInjectDetailsType: ResolverTypeWrapper<CustomInjectDetailsType>;
  CustomInjectInput: CustomInjectInput;
  CustomInjectType: ResolverTypeWrapper<CustomInjectType>;
  DateTime: ResolverTypeWrapper<Scalars['DateTime']['output']>;
  DefinitionChannelType: ResolverTypeWrapper<Omit<DefinitionChannelType, 'definition'> & { definition: ResolversTypes['DefinitionType'] }>;
  DefinitionInjectType: ResolverTypeWrapper<DefinitionInjectType>;
  DefinitionRoleType: ResolverTypeWrapper<Omit<DefinitionRoleType, 'definition'> & { definition: ResolversTypes['DefinitionType'] }>;
  DefinitionType: ResolverTypeWrapper<Omit<DefinitionType, 'channels' | 'exercises' | 'learningObjectives' | 'roles'> & { channels: Array<ResolversTypes['DefinitionChannelType']>, exercises: Array<ResolversTypes['ExerciseType']>, learningObjectives: Array<ResolversTypes['LearningObjectiveType']>, roles: Array<ResolversTypes['DefinitionRoleType']> }>;
  DeleteDefinitionMutation: ResolverTypeWrapper<DeleteDefinitionMutation>;
  DeleteExerciseMutation: ResolverTypeWrapper<DeleteExerciseMutation>;
  DeleteTagsMutation: ResolverTypeWrapper<DeleteTagsMutation>;
  DeleteUsersMutation: ResolverTypeWrapper<DeleteUsersMutation>;
  EmailAddressType: ResolverTypeWrapper<EmailAddressType>;
  EmailDraftInput: EmailDraftInput;
  EmailDraftType: ResolverTypeWrapper<EmailDraftType>;
  EmailParticipantType: ResolverTypeWrapper<Omit<EmailParticipantType, 'exercise' | 'team'> & { exercise: ResolversTypes['ExerciseType'], team?: Maybe<ResolversTypes['TeamType']> }>;
  EmailReceipt: ResolverTypeWrapper<EmailReceipt>;
  EmailTemplateType: ResolverTypeWrapper<EmailTemplateType>;
  EmailThreadSubscription: ResolverTypeWrapper<EmailThreadSubscription>;
  EmailThreadType: ResolverTypeWrapper<Omit<EmailThreadType, 'exercise' | 'participants'> & { exercise: ResolversTypes['ExerciseType'], participants: Array<ResolversTypes['EmailParticipantType']> }>;
  EmailType: ResolverTypeWrapper<Omit<EmailType, 'sender'> & { sender: ResolversTypes['EmailParticipantType'] }>;
  ExerciseDefinitionType: ResolverTypeWrapper<ExerciseDefinitionType>;
  ExerciseEventTypeEnum: ExerciseEventTypeEnum;
  ExerciseLoopRunningSubscription: ResolverTypeWrapper<ExerciseLoopRunningSubscription>;
  ExerciseType: ResolverTypeWrapper<Omit<ExerciseType, 'emailParticipants' | 'teams'> & { emailParticipants: Array<ResolversTypes['EmailParticipantType']>, teams: Array<ResolversTypes['TeamType']> }>;
  ExercisesSubscription: ResolverTypeWrapper<Omit<ExercisesSubscription, 'exercise'> & { exercise?: Maybe<ResolversTypes['ExerciseType']> }>;
  ExtendedToolType: ResolverTypeWrapper<ExtendedToolType>;
  FileInfoType: ResolverTypeWrapper<Omit<FileInfoType, 'definition'> & { definition?: Maybe<ResolversTypes['DefinitionType']> }>;
  FilterUsersInput: FilterUsersInput;
  FilterUsersType: ResolverTypeWrapper<FilterUsersType>;
  GrapheneConfig: ResolverTypeWrapper<GrapheneConfig>;
  ID: ResolverTypeWrapper<Scalars['ID']['output']>;
  InjectDetailsType: ResolverTypeWrapper<InjectDetailsType>;
  InjectType: InjectType;
  Int: ResolverTypeWrapper<Scalars['Int']['output']>;
  IsUnreadType: ResolverTypeWrapper<IsUnreadType>;
  LearningActivityType: ResolverTypeWrapper<Omit<LearningActivityType, 'objective'> & { objective: ResolversTypes['LearningObjectiveType'] }>;
  LearningObjectiveType: ResolverTypeWrapper<Omit<LearningObjectiveType, 'definition'> & { definition: ResolversTypes['DefinitionType'] }>;
  LogType: LogType;
  LoginMutation: ResolverTypeWrapper<Omit<LoginMutation, 'user'> & { user?: Maybe<ResolversTypes['UserType']> }>;
  LogoutMutation: ResolverTypeWrapper<LogoutMutation>;
  MilestoneStateType: ResolverTypeWrapper<Omit<MilestoneStateType, 'activity'> & { activity?: Maybe<ResolversTypes['TeamLearningActivityType']> }>;
  MilestoneType: ResolverTypeWrapper<MilestoneType>;
  MilestonesSubscription: ResolverTypeWrapper<Omit<MilestonesSubscription, 'milestones'> & { milestones?: Maybe<Array<Maybe<ResolversTypes['MilestoneStateType']>>> }>;
  ModifyMilestoneMutation: ResolverTypeWrapper<ModifyMilestoneMutation>;
  MoveExerciseTimeMutation: ResolverTypeWrapper<Omit<MoveExerciseTimeMutation, 'exercise'> & { exercise?: Maybe<ResolversTypes['ExerciseType']> }>;
  Mutation: ResolverTypeWrapper<{}>;
  MutationResult: ResolverTypeWrapper<MutationResult>;
  OverlayInput: OverlayInput;
  OverlayType: ResolverTypeWrapper<OverlayType>;
  PasswordChange: ResolverTypeWrapper<PasswordChange>;
  Query: ResolverTypeWrapper<{}>;
  QuestionType: ResolverTypeWrapper<QuestionType>;
  QuestionnaireAnswerType: ResolverTypeWrapper<Omit<QuestionnaireAnswerType, 'teamQuestionnaireState'> & { teamQuestionnaireState: ResolversTypes['TeamQuestionnaireStateType'] }>;
  QuestionnaireInput: QuestionnaireInput;
  QuestionnaireType: ResolverTypeWrapper<Omit<QuestionnaireType, 'definition' | 'teamQuestionnaireStates'> & { definition: ResolversTypes['DefinitionType'], teamQuestionnaireStates: Array<ResolversTypes['TeamQuestionnaireStateType']> }>;
  ReadReceiptType: ResolverTypeWrapper<ReadReceiptType>;
  RegenerateCredentialsMutation: ResolverTypeWrapper<RegenerateCredentialsMutation>;
  RemoveDefinitionAccessMutation: ResolverTypeWrapper<RemoveDefinitionAccessMutation>;
  RemoveInstructorsFromExerciseMutation: ResolverTypeWrapper<RemoveInstructorsFromExerciseMutation>;
  RemoveUsersFromTeamMutation: ResolverTypeWrapper<RemoveUsersFromTeamMutation>;
  RestrictedExercise: ResolverTypeWrapper<RestrictedExercise>;
  RestrictedTeam: ResolverTypeWrapper<Omit<RestrictedTeam, 'emailAddress' | 'exercise'> & { emailAddress?: Maybe<ResolversTypes['EmailParticipantType']>, exercise: ResolversTypes['ExerciseType'] }>;
  RestrictedUser: ResolverTypeWrapper<RestrictedUser>;
  SendCustomInjectMutation: ResolverTypeWrapper<SendCustomInjectMutation>;
  SendEmailInput: SendEmailInput;
  SendEmailMutation: ResolverTypeWrapper<SendEmailMutation>;
  SendEmailType: ResolverTypeWrapper<SendEmailType>;
  StartExerciseMutation: ResolverTypeWrapper<Omit<StartExerciseMutation, 'exercise'> & { exercise?: Maybe<ResolversTypes['ExerciseType']> }>;
  Status: Status;
  StopExerciseMutation: ResolverTypeWrapper<Omit<StopExerciseMutation, 'exercise'> & { exercise?: Maybe<ResolversTypes['ExerciseType']> }>;
  String: ResolverTypeWrapper<Scalars['String']['output']>;
  Subscription: ResolverTypeWrapper<{}>;
  TagType: ResolverTypeWrapper<TagType>;
  TeamLearningActivityType: ResolverTypeWrapper<Omit<TeamLearningActivityType, 'milestoneStates' | 'teamObjective'> & { milestoneStates: Array<ResolversTypes['MilestoneStateType']>, teamObjective: ResolversTypes['TeamLearningObjectiveType'] }>;
  TeamLearningObjectiveType: ResolverTypeWrapper<Omit<TeamLearningObjectiveType, 'activities' | 'objective'> & { activities: Array<ResolversTypes['TeamLearningActivityType']>, objective: ResolversTypes['LearningObjectiveType'] }>;
  TeamQuestionnaireStateSubscription: ResolverTypeWrapper<Omit<TeamQuestionnaireStateSubscription, 'teamQuestionnaireState'> & { teamQuestionnaireState: ResolversTypes['TeamQuestionnaireStateType'] }>;
  TeamQuestionnaireStateType: ResolverTypeWrapper<Omit<TeamQuestionnaireStateType, 'team'> & { team: ResolversTypes['TeamType'] }>;
  TeamType: ResolverTypeWrapper<Omit<TeamType, 'emailAddress' | 'exercise' | 'logs' | 'teamQuestionnaireStates'> & { emailAddress?: Maybe<ResolversTypes['EmailParticipantType']>, exercise: ResolversTypes['ExerciseType'], logs: Array<ResolversTypes['ActionLogType']>, teamQuestionnaireStates: Array<ResolversTypes['TeamQuestionnaireStateType']> }>;
  ToolDetailsType: ResolverTypeWrapper<ToolDetailsType>;
  ToolResponseType: ResolverTypeWrapper<ToolResponseType>;
  ToolType: ResolverTypeWrapper<ToolType>;
  UUID: ResolverTypeWrapper<Scalars['UUID']['output']>;
  UpdateTagAssignmentsInput: UpdateTagAssignmentsInput;
  UpdateTagAssignmentsMutation: ResolverTypeWrapper<UpdateTagAssignmentsMutation>;
  UpdateTagAssignmentsType: ResolverTypeWrapper<UpdateTagAssignmentsType>;
  UpdateTagMutation: ResolverTypeWrapper<UpdateTagMutation>;
  UseToolInput: UseToolInput;
  UseToolMutation: ResolverTypeWrapper<UseToolMutation>;
  UseToolType: ResolverTypeWrapper<UseToolType>;
  UserType: ResolverTypeWrapper<Omit<UserType, 'exercises' | 'teams'> & { exercises?: Maybe<Array<Maybe<ResolversTypes['RestrictedExercise']>>>, teams?: Maybe<Array<Maybe<ResolversTypes['RestrictedTeam']>>> }>;
}>;

/** Mapping between all available schema types and the resolvers parents */
export type ResolversParentTypes = ResolversObject<{
  ActionLogDetails: ResolversUnionTypes<ResolversParentTypes>['ActionLogDetails'];
  ActionLogType: Omit<ActionLogType, 'channel' | 'details' | 'team'> & { channel: ResolversParentTypes['DefinitionChannelType'], details: ResolversParentTypes['ActionLogDetails'], team: ResolversParentTypes['TeamType'] };
  ActionLogsSubscription: Omit<ActionLogsSubscription, 'actionLog'> & { actionLog?: Maybe<ResolversParentTypes['ActionLogType']> };
  AddDefinitionAccessMutation: AddDefinitionAccessMutation;
  AnalyticsActionLogsSubscription: Omit<AnalyticsActionLogsSubscription, 'actionLog'> & { actionLog?: Maybe<ResolversParentTypes['ActionLogType']> };
  AnalyticsEmailThreadSubscription: AnalyticsEmailThreadSubscription;
  AnalyticsMilestonesSubscription: Omit<AnalyticsMilestonesSubscription, 'milestones'> & { milestones?: Maybe<Array<Maybe<ResolversParentTypes['MilestoneStateType']>>> };
  AnswerInput: AnswerInput;
  AnswerQuestionnaireMutation: AnswerQuestionnaireMutation;
  AssignInstructorsToExercise: AssignInstructorsToExercise;
  AssignUsersByTags: AssignUsersByTags;
  AssignUsersEqually: AssignUsersEqually;
  AssignUsersToTeamMutation: AssignUsersToTeamMutation;
  Boolean: Scalars['Boolean']['output'];
  ChangeUserDataMutation: Omit<ChangeUserDataMutation, 'user'> & { user?: Maybe<ResolversParentTypes['UserType']> };
  ChangeUserInput: ChangeUserInput;
  ChangeUserType: ChangeUserType;
  ChannelReceipt: ChannelReceipt;
  ConfigOverrideInput: ConfigOverrideInput;
  ConfigOverrideType: ConfigOverrideType;
  ContentType: ContentType;
  ControlType: ControlType;
  CopyUsersAssignment: CopyUsersAssignment;
  CreateExerciseInput: CreateExerciseInput;
  CreateExerciseMutation: Omit<CreateExerciseMutation, 'exercise'> & { exercise?: Maybe<ResolversParentTypes['ExerciseType']> };
  CreateExerciseType: CreateExerciseType;
  CreateTagMutation: CreateTagMutation;
  CreateThreadMutation: CreateThreadMutation;
  CreateUserInput: CreateUserInput;
  CreateUserMutation: CreateUserMutation;
  CreateUserType: CreateUserType;
  CustomInjectDetailsType: CustomInjectDetailsType;
  CustomInjectInput: CustomInjectInput;
  CustomInjectType: CustomInjectType;
  DateTime: Scalars['DateTime']['output'];
  DefinitionChannelType: Omit<DefinitionChannelType, 'definition'> & { definition: ResolversParentTypes['DefinitionType'] };
  DefinitionInjectType: DefinitionInjectType;
  DefinitionRoleType: Omit<DefinitionRoleType, 'definition'> & { definition: ResolversParentTypes['DefinitionType'] };
  DefinitionType: Omit<DefinitionType, 'channels' | 'exercises' | 'learningObjectives' | 'roles'> & { channels: Array<ResolversParentTypes['DefinitionChannelType']>, exercises: Array<ResolversParentTypes['ExerciseType']>, learningObjectives: Array<ResolversParentTypes['LearningObjectiveType']>, roles: Array<ResolversParentTypes['DefinitionRoleType']> };
  DeleteDefinitionMutation: DeleteDefinitionMutation;
  DeleteExerciseMutation: DeleteExerciseMutation;
  DeleteTagsMutation: DeleteTagsMutation;
  DeleteUsersMutation: DeleteUsersMutation;
  EmailAddressType: EmailAddressType;
  EmailDraftInput: EmailDraftInput;
  EmailDraftType: EmailDraftType;
  EmailParticipantType: Omit<EmailParticipantType, 'exercise' | 'team'> & { exercise: ResolversParentTypes['ExerciseType'], team?: Maybe<ResolversParentTypes['TeamType']> };
  EmailReceipt: EmailReceipt;
  EmailTemplateType: EmailTemplateType;
  EmailThreadSubscription: EmailThreadSubscription;
  EmailThreadType: Omit<EmailThreadType, 'exercise' | 'participants'> & { exercise: ResolversParentTypes['ExerciseType'], participants: Array<ResolversParentTypes['EmailParticipantType']> };
  EmailType: Omit<EmailType, 'sender'> & { sender: ResolversParentTypes['EmailParticipantType'] };
  ExerciseDefinitionType: ExerciseDefinitionType;
  ExerciseLoopRunningSubscription: ExerciseLoopRunningSubscription;
  ExerciseType: Omit<ExerciseType, 'emailParticipants' | 'teams'> & { emailParticipants: Array<ResolversParentTypes['EmailParticipantType']>, teams: Array<ResolversParentTypes['TeamType']> };
  ExercisesSubscription: Omit<ExercisesSubscription, 'exercise'> & { exercise?: Maybe<ResolversParentTypes['ExerciseType']> };
  ExtendedToolType: ExtendedToolType;
  FileInfoType: Omit<FileInfoType, 'definition'> & { definition?: Maybe<ResolversParentTypes['DefinitionType']> };
  FilterUsersInput: FilterUsersInput;
  FilterUsersType: FilterUsersType;
  GrapheneConfig: GrapheneConfig;
  ID: Scalars['ID']['output'];
  InjectDetailsType: InjectDetailsType;
  Int: Scalars['Int']['output'];
  IsUnreadType: IsUnreadType;
  LearningActivityType: Omit<LearningActivityType, 'objective'> & { objective: ResolversParentTypes['LearningObjectiveType'] };
  LearningObjectiveType: Omit<LearningObjectiveType, 'definition'> & { definition: ResolversParentTypes['DefinitionType'] };
  LoginMutation: Omit<LoginMutation, 'user'> & { user?: Maybe<ResolversParentTypes['UserType']> };
  LogoutMutation: LogoutMutation;
  MilestoneStateType: Omit<MilestoneStateType, 'activity'> & { activity?: Maybe<ResolversParentTypes['TeamLearningActivityType']> };
  MilestoneType: MilestoneType;
  MilestonesSubscription: Omit<MilestonesSubscription, 'milestones'> & { milestones?: Maybe<Array<Maybe<ResolversParentTypes['MilestoneStateType']>>> };
  ModifyMilestoneMutation: ModifyMilestoneMutation;
  MoveExerciseTimeMutation: Omit<MoveExerciseTimeMutation, 'exercise'> & { exercise?: Maybe<ResolversParentTypes['ExerciseType']> };
  Mutation: {};
  MutationResult: MutationResult;
  OverlayInput: OverlayInput;
  OverlayType: OverlayType;
  PasswordChange: PasswordChange;
  Query: {};
  QuestionType: QuestionType;
  QuestionnaireAnswerType: Omit<QuestionnaireAnswerType, 'teamQuestionnaireState'> & { teamQuestionnaireState: ResolversParentTypes['TeamQuestionnaireStateType'] };
  QuestionnaireInput: QuestionnaireInput;
  QuestionnaireType: Omit<QuestionnaireType, 'definition' | 'teamQuestionnaireStates'> & { definition: ResolversParentTypes['DefinitionType'], teamQuestionnaireStates: Array<ResolversParentTypes['TeamQuestionnaireStateType']> };
  ReadReceiptType: ReadReceiptType;
  RegenerateCredentialsMutation: RegenerateCredentialsMutation;
  RemoveDefinitionAccessMutation: RemoveDefinitionAccessMutation;
  RemoveInstructorsFromExerciseMutation: RemoveInstructorsFromExerciseMutation;
  RemoveUsersFromTeamMutation: RemoveUsersFromTeamMutation;
  RestrictedExercise: RestrictedExercise;
  RestrictedTeam: Omit<RestrictedTeam, 'emailAddress' | 'exercise'> & { emailAddress?: Maybe<ResolversParentTypes['EmailParticipantType']>, exercise: ResolversParentTypes['ExerciseType'] };
  RestrictedUser: RestrictedUser;
  SendCustomInjectMutation: SendCustomInjectMutation;
  SendEmailInput: SendEmailInput;
  SendEmailMutation: SendEmailMutation;
  SendEmailType: SendEmailType;
  StartExerciseMutation: Omit<StartExerciseMutation, 'exercise'> & { exercise?: Maybe<ResolversParentTypes['ExerciseType']> };
  StopExerciseMutation: Omit<StopExerciseMutation, 'exercise'> & { exercise?: Maybe<ResolversParentTypes['ExerciseType']> };
  String: Scalars['String']['output'];
  Subscription: {};
  TagType: TagType;
  TeamLearningActivityType: Omit<TeamLearningActivityType, 'milestoneStates' | 'teamObjective'> & { milestoneStates: Array<ResolversParentTypes['MilestoneStateType']>, teamObjective: ResolversParentTypes['TeamLearningObjectiveType'] };
  TeamLearningObjectiveType: Omit<TeamLearningObjectiveType, 'activities' | 'objective'> & { activities: Array<ResolversParentTypes['TeamLearningActivityType']>, objective: ResolversParentTypes['LearningObjectiveType'] };
  TeamQuestionnaireStateSubscription: Omit<TeamQuestionnaireStateSubscription, 'teamQuestionnaireState'> & { teamQuestionnaireState: ResolversParentTypes['TeamQuestionnaireStateType'] };
  TeamQuestionnaireStateType: Omit<TeamQuestionnaireStateType, 'team'> & { team: ResolversParentTypes['TeamType'] };
  TeamType: Omit<TeamType, 'emailAddress' | 'exercise' | 'logs' | 'teamQuestionnaireStates'> & { emailAddress?: Maybe<ResolversParentTypes['EmailParticipantType']>, exercise: ResolversParentTypes['ExerciseType'], logs: Array<ResolversParentTypes['ActionLogType']>, teamQuestionnaireStates: Array<ResolversParentTypes['TeamQuestionnaireStateType']> };
  ToolDetailsType: ToolDetailsType;
  ToolResponseType: ToolResponseType;
  ToolType: ToolType;
  UUID: Scalars['UUID']['output'];
  UpdateTagAssignmentsInput: UpdateTagAssignmentsInput;
  UpdateTagAssignmentsMutation: UpdateTagAssignmentsMutation;
  UpdateTagAssignmentsType: UpdateTagAssignmentsType;
  UpdateTagMutation: UpdateTagMutation;
  UseToolInput: UseToolInput;
  UseToolMutation: UseToolMutation;
  UseToolType: UseToolType;
  UserType: Omit<UserType, 'exercises' | 'teams'> & { exercises?: Maybe<Array<Maybe<ResolversParentTypes['RestrictedExercise']>>>, teams?: Maybe<Array<Maybe<ResolversParentTypes['RestrictedTeam']>>> };
}>;

export type ActionLogDetailsResolvers<ContextType = any, ParentType extends ResolversParentTypes['ActionLogDetails'] = ResolversParentTypes['ActionLogDetails']> = ResolversObject<{
  __resolveType: TypeResolveFn<'CustomInjectDetailsType' | 'EmailType' | 'InjectDetailsType' | 'QuestionnaireType' | 'ToolDetailsType', ParentType, ContextType>;
}>;

export type ActionLogTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ActionLogType'] = ResolversParentTypes['ActionLogType']> = ResolversObject<{
  channel?: Resolver<ResolversTypes['DefinitionChannelType'], ParentType, ContextType>;
  details?: Resolver<ResolversTypes['ActionLogDetails'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  readReceipt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  team?: Resolver<ResolversTypes['TeamType'], ParentType, ContextType>;
  timestamp?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['LogType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ActionLogsSubscriptionResolvers<ContextType = any, ParentType extends ResolversParentTypes['ActionLogsSubscription'] = ResolversParentTypes['ActionLogsSubscription']> = ResolversObject<{
  actionLog?: Resolver<Maybe<ResolversTypes['ActionLogType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AddDefinitionAccessMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['AddDefinitionAccessMutation'] = ResolversParentTypes['AddDefinitionAccessMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AnalyticsActionLogsSubscriptionResolvers<ContextType = any, ParentType extends ResolversParentTypes['AnalyticsActionLogsSubscription'] = ResolversParentTypes['AnalyticsActionLogsSubscription']> = ResolversObject<{
  actionLog?: Resolver<Maybe<ResolversTypes['ActionLogType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AnalyticsEmailThreadSubscriptionResolvers<ContextType = any, ParentType extends ResolversParentTypes['AnalyticsEmailThreadSubscription'] = ResolversParentTypes['AnalyticsEmailThreadSubscription']> = ResolversObject<{
  emailThread?: Resolver<Maybe<ResolversTypes['EmailThreadType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AnalyticsMilestonesSubscriptionResolvers<ContextType = any, ParentType extends ResolversParentTypes['AnalyticsMilestonesSubscription'] = ResolversParentTypes['AnalyticsMilestonesSubscription']> = ResolversObject<{
  milestones?: Resolver<Maybe<Array<Maybe<ResolversTypes['MilestoneStateType']>>>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AnswerQuestionnaireMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['AnswerQuestionnaireMutation'] = ResolversParentTypes['AnswerQuestionnaireMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AssignInstructorsToExerciseResolvers<ContextType = any, ParentType extends ResolversParentTypes['AssignInstructorsToExercise'] = ResolversParentTypes['AssignInstructorsToExercise']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AssignUsersByTagsResolvers<ContextType = any, ParentType extends ResolversParentTypes['AssignUsersByTags'] = ResolversParentTypes['AssignUsersByTags']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AssignUsersEquallyResolvers<ContextType = any, ParentType extends ResolversParentTypes['AssignUsersEqually'] = ResolversParentTypes['AssignUsersEqually']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AssignUsersToTeamMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['AssignUsersToTeamMutation'] = ResolversParentTypes['AssignUsersToTeamMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ChangeUserDataMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['ChangeUserDataMutation'] = ResolversParentTypes['ChangeUserDataMutation']> = ResolversObject<{
  user?: Resolver<Maybe<ResolversTypes['UserType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ChangeUserTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ChangeUserType'] = ResolversParentTypes['ChangeUserType']> = ResolversObject<{
  active?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  group?: Resolver<Maybe<ResolversTypes['AuthGroup']>, ParentType, ContextType>;
  userId?: Resolver<ResolversTypes['UUID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ChannelReceiptResolvers<ContextType = any, ParentType extends ResolversParentTypes['ChannelReceipt'] = ResolversParentTypes['ChannelReceipt']> = ResolversObject<{
  channelId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  readReceipt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  teamId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ConfigOverrideTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ConfigOverrideType'] = ResolversParentTypes['ConfigOverrideType']> = ResolversObject<{
  customEmailSuffix?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  customTeamNames?: Resolver<Maybe<Array<ResolversTypes['String']>>, ParentType, ContextType>;
  emailBetweenTeams?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  exerciseDuration?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  showExerciseTime?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ContentTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ContentType'] = ResolversParentTypes['ContentType']> = ResolversObject<{
  fileInfo?: Resolver<Maybe<ResolversTypes['FileInfoType']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  raw?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  rendered?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ControlTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ControlType'] = ResolversParentTypes['ControlType']> = ResolversObject<{
  activateMilestone?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  deactivateMilestone?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  milestoneCondition?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  roles?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CopyUsersAssignmentResolvers<ContextType = any, ParentType extends ResolversParentTypes['CopyUsersAssignment'] = ResolversParentTypes['CopyUsersAssignment']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CreateExerciseMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['CreateExerciseMutation'] = ResolversParentTypes['CreateExerciseMutation']> = ResolversObject<{
  exercise?: Resolver<Maybe<ResolversTypes['ExerciseType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CreateExerciseTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['CreateExerciseType'] = ResolversParentTypes['CreateExerciseType']> = ResolversObject<{
  configOverride?: Resolver<Maybe<ResolversTypes['ConfigOverrideType']>, ParentType, ContextType>;
  definitionId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  teamCount?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CreateTagMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['CreateTagMutation'] = ResolversParentTypes['CreateTagMutation']> = ResolversObject<{
  newTag?: Resolver<ResolversTypes['TagType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CreateThreadMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['CreateThreadMutation'] = ResolversParentTypes['CreateThreadMutation']> = ResolversObject<{
  thread?: Resolver<Maybe<ResolversTypes['EmailThreadType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CreateUserMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['CreateUserMutation'] = ResolversParentTypes['CreateUserMutation']> = ResolversObject<{
  newUser?: Resolver<ResolversTypes['RestrictedUser'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CreateUserTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['CreateUserType'] = ResolversParentTypes['CreateUserType']> = ResolversObject<{
  email?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  firstName?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  group?: Resolver<Maybe<ResolversTypes['AuthGroup']>, ParentType, ContextType>;
  lastName?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  tags?: Resolver<Array<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CustomInjectDetailsTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['CustomInjectDetailsType'] = ResolversParentTypes['CustomInjectDetailsType']> = ResolversObject<{
  content?: Resolver<ResolversTypes['ContentType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  overlay?: Resolver<Maybe<ResolversTypes['OverlayType']>, ParentType, ContextType>;
  user?: Resolver<Maybe<ResolversTypes['RestrictedUser']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CustomInjectTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['CustomInjectType'] = ResolversParentTypes['CustomInjectType']> = ResolversObject<{
  content?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  exerciseId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  fileId?: Resolver<Maybe<ResolversTypes['UUID']>, ParentType, ContextType>;
  overlay?: Resolver<Maybe<ResolversTypes['OverlayType']>, ParentType, ContextType>;
  teamIds?: Resolver<Array<Maybe<ResolversTypes['ID']>>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export interface DateTimeScalarConfig extends GraphQLScalarTypeConfig<ResolversTypes['DateTime'], any> {
  name: 'DateTime';
}

export type DefinitionChannelTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['DefinitionChannelType'] = ResolversParentTypes['DefinitionChannelType']> = ResolversObject<{
  definition?: Resolver<ResolversTypes['DefinitionType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  readReceipt?: Resolver<Array<ResolversTypes['IsUnreadType']>, ParentType, ContextType>;
  type?: Resolver<ResolversTypes['ChannelType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DefinitionInjectTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['DefinitionInjectType'] = ResolversParentTypes['DefinitionInjectType']> = ResolversObject<{
  delay?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  organization?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  time?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['InjectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DefinitionRoleTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['DefinitionRoleType'] = ResolversParentTypes['DefinitionRoleType']> = ResolversObject<{
  definition?: Resolver<ResolversTypes['DefinitionType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DefinitionTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['DefinitionType'] = ResolversParentTypes['DefinitionType']> = ResolversObject<{
  addresses?: Resolver<Array<ResolversTypes['EmailAddressType']>, ParentType, ContextType>;
  channels?: Resolver<Array<ResolversTypes['DefinitionChannelType']>, ParentType, ContextType>;
  exercises?: Resolver<Array<ResolversTypes['ExerciseType']>, ParentType, ContextType>;
  files?: Resolver<Array<ResolversTypes['FileInfoType']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  injects?: Resolver<Array<ResolversTypes['DefinitionInjectType']>, ParentType, ContextType>;
  learningObjectives?: Resolver<Array<ResolversTypes['LearningObjectiveType']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  questionnaires?: Resolver<Array<ResolversTypes['QuestionnaireType']>, ParentType, ContextType>;
  roles?: Resolver<Array<ResolversTypes['DefinitionRoleType']>, ParentType, ContextType>;
  tools?: Resolver<Array<ResolversTypes['ToolType']>, ParentType, ContextType>;
  userSet?: Resolver<Maybe<Array<Maybe<ResolversTypes['RestrictedUser']>>>, ParentType, ContextType>;
  version?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DeleteDefinitionMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['DeleteDefinitionMutation'] = ResolversParentTypes['DeleteDefinitionMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DeleteExerciseMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['DeleteExerciseMutation'] = ResolversParentTypes['DeleteExerciseMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DeleteTagsMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['DeleteTagsMutation'] = ResolversParentTypes['DeleteTagsMutation']> = ResolversObject<{
  operationDone?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DeleteUsersMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['DeleteUsersMutation'] = ResolversParentTypes['DeleteUsersMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type EmailAddressTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['EmailAddressType'] = ResolversParentTypes['EmailAddressType']> = ResolversObject<{
  address?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  control?: Resolver<ResolversTypes['ControlType'], ParentType, ContextType>;
  definition?: Resolver<Maybe<ResolversTypes['ExerciseDefinitionType']>, ParentType, ContextType>;
  description?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  organization?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  teamVisible?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  templates?: Resolver<Array<ResolversTypes['EmailTemplateType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type EmailDraftTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['EmailDraftType'] = ResolversParentTypes['EmailDraftType']> = ResolversObject<{
  activateMilestone?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  content?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  deactivateMilestone?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  emailThreadId?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  fileId?: Resolver<Maybe<ResolversTypes['UUID']>, ParentType, ContextType>;
  instructor?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  selectedContacts?: Resolver<Maybe<Array<Maybe<ResolversTypes['String']>>>, ParentType, ContextType>;
  senderAddress?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  subject?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  teamId?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  templateId?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type EmailParticipantTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['EmailParticipantType'] = ResolversParentTypes['EmailParticipantType']> = ResolversObject<{
  address?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  definitionAddress?: Resolver<Maybe<ResolversTypes['EmailAddressType']>, ParentType, ContextType>;
  emails?: Resolver<Array<ResolversTypes['EmailType']>, ParentType, ContextType>;
  exercise?: Resolver<ResolversTypes['ExerciseType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  team?: Resolver<Maybe<ResolversTypes['TeamType']>, ParentType, ContextType>;
  threads?: Resolver<Array<ResolversTypes['EmailThreadType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type EmailReceiptResolvers<ContextType = any, ParentType extends ResolversParentTypes['EmailReceipt'] = ResolversParentTypes['EmailReceipt']> = ResolversObject<{
  emailId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  readReceipt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type EmailTemplateTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['EmailTemplateType'] = ResolversParentTypes['EmailTemplateType']> = ResolversObject<{
  content?: Resolver<ResolversTypes['ContentType'], ParentType, ContextType>;
  context?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  control?: Resolver<ResolversTypes['ControlType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  sender?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type EmailThreadSubscriptionResolvers<ContextType = any, ParentType extends ResolversParentTypes['EmailThreadSubscription'] = ResolversParentTypes['EmailThreadSubscription']> = ResolversObject<{
  emailThread?: Resolver<Maybe<ResolversTypes['EmailThreadType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type EmailThreadTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['EmailThreadType'] = ResolversParentTypes['EmailThreadType']> = ResolversObject<{
  emails?: Resolver<Array<ResolversTypes['EmailType']>, ParentType, ContextType>;
  exercise?: Resolver<ResolversTypes['ExerciseType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  lastEmail?: Resolver<Maybe<ResolversTypes['EmailType']>, ParentType, ContextType>;
  participants?: Resolver<Array<ResolversTypes['EmailParticipantType']>, ParentType, ContextType>;
  readReceipt?: Resolver<Array<ResolversTypes['IsUnreadType']>, ParentType, ContextType>;
  subject?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  timestamp?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type EmailTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['EmailType'] = ResolversParentTypes['EmailType']> = ResolversObject<{
  content?: Resolver<ResolversTypes['ContentType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  overlay?: Resolver<Maybe<ResolversTypes['OverlayType']>, ParentType, ContextType>;
  readReceipt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  sender?: Resolver<ResolversTypes['EmailParticipantType'], ParentType, ContextType>;
  thread?: Resolver<ResolversTypes['EmailThreadType'], ParentType, ContextType>;
  timestamp?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  user?: Resolver<Maybe<ResolversTypes['RestrictedUser']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ExerciseDefinitionTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ExerciseDefinitionType'] = ResolversParentTypes['ExerciseDefinitionType']> = ResolversObject<{
  id?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  name?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ExerciseLoopRunningSubscriptionResolvers<ContextType = any, ParentType extends ResolversParentTypes['ExerciseLoopRunningSubscription'] = ResolversParentTypes['ExerciseLoopRunningSubscription']> = ResolversObject<{
  exerciseLoopRunning?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ExerciseTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ExerciseType'] = ResolversParentTypes['ExerciseType']> = ResolversObject<{
  definition?: Resolver<Maybe<ResolversTypes['ExerciseDefinitionType']>, ParentType, ContextType>;
  elapsedS?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  emailParticipants?: Resolver<Array<ResolversTypes['EmailParticipantType']>, ParentType, ContextType>;
  exerciseStart?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  finished?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  running?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  teams?: Resolver<Array<ResolversTypes['TeamType']>, ParentType, ContextType>;
  threads?: Resolver<Array<ResolversTypes['EmailThreadType']>, ParentType, ContextType>;
  userSet?: Resolver<Maybe<Array<Maybe<ResolversTypes['RestrictedUser']>>>, ParentType, ContextType>;
  uuid?: Resolver<ResolversTypes['UUID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ExercisesSubscriptionResolvers<ContextType = any, ParentType extends ResolversParentTypes['ExercisesSubscription'] = ResolversParentTypes['ExercisesSubscription']> = ResolversObject<{
  eventType?: Resolver<Maybe<ResolversTypes['ExerciseEventTypeEnum']>, ParentType, ContextType>;
  exercise?: Resolver<Maybe<ResolversTypes['ExerciseType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ExtendedToolTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ExtendedToolType'] = ResolversParentTypes['ExtendedToolType']> = ResolversObject<{
  defaultResponse?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  definition?: Resolver<Maybe<ResolversTypes['ExerciseDefinitionType']>, ParentType, ContextType>;
  hint?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  responses?: Resolver<Array<ResolversTypes['ToolResponseType']>, ParentType, ContextType>;
  roles?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  tooltipDescription?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type FileInfoTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['FileInfoType'] = ResolversParentTypes['FileInfoType']> = ResolversObject<{
  definition?: Resolver<Maybe<ResolversTypes['DefinitionType']>, ParentType, ContextType>;
  fileName?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['UUID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type FilterUsersTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['FilterUsersType'] = ResolversParentTypes['FilterUsersType']> = ResolversObject<{
  active?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  firstName?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  groups?: Resolver<Maybe<Array<Maybe<ResolversTypes['AuthGroup']>>>, ParentType, ContextType>;
  imported?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  lastName?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  limit?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  skip?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  tags?: Resolver<Maybe<Array<Maybe<ResolversTypes['String']>>>, ParentType, ContextType>;
  username?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GrapheneConfigResolvers<ContextType = any, ParentType extends ResolversParentTypes['GrapheneConfig'] = ResolversParentTypes['GrapheneConfig']> = ResolversObject<{
  customEmailSuffix?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  emailBetweenTeams?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  enableRoles?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  exerciseDuration?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  showExerciseTime?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type InjectDetailsTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['InjectDetailsType'] = ResolversParentTypes['InjectDetailsType']> = ResolversObject<{
  content?: Resolver<ResolversTypes['ContentType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  inject?: Resolver<ResolversTypes['DefinitionInjectType'], ParentType, ContextType>;
  overlay?: Resolver<Maybe<ResolversTypes['OverlayType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type IsUnreadTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['IsUnreadType'] = ResolversParentTypes['IsUnreadType']> = ResolversObject<{
  isUnread?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  teamId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LearningActivityTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['LearningActivityType'] = ResolversParentTypes['LearningActivityType']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  milestones?: Resolver<Array<ResolversTypes['MilestoneType']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  objective?: Resolver<ResolversTypes['LearningObjectiveType'], ParentType, ContextType>;
  tags?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LearningObjectiveTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['LearningObjectiveType'] = ResolversParentTypes['LearningObjectiveType']> = ResolversObject<{
  activities?: Resolver<Array<ResolversTypes['LearningActivityType']>, ParentType, ContextType>;
  definition?: Resolver<ResolversTypes['DefinitionType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  tags?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LoginMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['LoginMutation'] = ResolversParentTypes['LoginMutation']> = ResolversObject<{
  user?: Resolver<Maybe<ResolversTypes['UserType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LogoutMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['LogoutMutation'] = ResolversParentTypes['LogoutMutation']> = ResolversObject<{
  loggedOut?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type MilestoneStateTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['MilestoneStateType'] = ResolversParentTypes['MilestoneStateType']> = ResolversObject<{
  activity?: Resolver<Maybe<ResolversTypes['TeamLearningActivityType']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  milestone?: Resolver<ResolversTypes['MilestoneType'], ParentType, ContextType>;
  reached?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  teamIds?: Resolver<Maybe<Array<Maybe<ResolversTypes['ID']>>>, ParentType, ContextType>;
  timestampReached?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type MilestoneTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['MilestoneType'] = ResolversParentTypes['MilestoneType']> = ResolversObject<{
  activity?: Resolver<Maybe<ResolversTypes['LearningActivityType']>, ParentType, ContextType>;
  fileNames?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  final?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  initialState?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  roles?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  teamVisible?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type MilestonesSubscriptionResolvers<ContextType = any, ParentType extends ResolversParentTypes['MilestonesSubscription'] = ResolversParentTypes['MilestonesSubscription']> = ResolversObject<{
  milestones?: Resolver<Maybe<Array<Maybe<ResolversTypes['MilestoneStateType']>>>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ModifyMilestoneMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['ModifyMilestoneMutation'] = ResolversParentTypes['ModifyMilestoneMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type MoveExerciseTimeMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['MoveExerciseTimeMutation'] = ResolversParentTypes['MoveExerciseTimeMutation']> = ResolversObject<{
  exercise?: Resolver<Maybe<ResolversTypes['ExerciseType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type MutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['Mutation'] = ResolversParentTypes['Mutation']> = ResolversObject<{
  addDefinitionAccess?: Resolver<Maybe<ResolversTypes['AddDefinitionAccessMutation']>, ParentType, ContextType, RequireFields<MutationAddDefinitionAccessArgs, 'definitionId' | 'userIds'>>;
  answerQuestionnaire?: Resolver<Maybe<ResolversTypes['AnswerQuestionnaireMutation']>, ParentType, ContextType, RequireFields<MutationAnswerQuestionnaireArgs, 'questInput'>>;
  assignInstructorsToExercise?: Resolver<Maybe<ResolversTypes['AssignInstructorsToExercise']>, ParentType, ContextType, RequireFields<MutationAssignInstructorsToExerciseArgs, 'exerciseId' | 'userIds'>>;
  assignUsersByTags?: Resolver<Maybe<ResolversTypes['AssignUsersByTags']>, ParentType, ContextType, RequireFields<MutationAssignUsersByTagsArgs, 'exerciseId' | 'tagPrefix' | 'userIds'>>;
  assignUsersEqually?: Resolver<Maybe<ResolversTypes['AssignUsersEqually']>, ParentType, ContextType, RequireFields<MutationAssignUsersEquallyArgs, 'exerciseId' | 'userIds'>>;
  assignUsersToTeam?: Resolver<Maybe<ResolversTypes['AssignUsersToTeamMutation']>, ParentType, ContextType, RequireFields<MutationAssignUsersToTeamArgs, 'teamId' | 'userIds'>>;
  changeUserData?: Resolver<Maybe<ResolversTypes['ChangeUserDataMutation']>, ParentType, ContextType, RequireFields<MutationChangeUserDataArgs, 'changeUserInput'>>;
  copyUsersAssignment?: Resolver<Maybe<ResolversTypes['CopyUsersAssignment']>, ParentType, ContextType, RequireFields<MutationCopyUsersAssignmentArgs, 'fromExerciseId' | 'toExerciseId'>>;
  createExercise?: Resolver<Maybe<ResolversTypes['CreateExerciseMutation']>, ParentType, ContextType, RequireFields<MutationCreateExerciseArgs, 'createExerciseInput'>>;
  createTag?: Resolver<Maybe<ResolversTypes['CreateTagMutation']>, ParentType, ContextType, RequireFields<MutationCreateTagArgs, 'name'>>;
  createThread?: Resolver<Maybe<ResolversTypes['CreateThreadMutation']>, ParentType, ContextType, RequireFields<MutationCreateThreadArgs, 'exerciseId' | 'participantAddresses' | 'subject'>>;
  createUser?: Resolver<Maybe<ResolversTypes['CreateUserMutation']>, ParentType, ContextType, RequireFields<MutationCreateUserArgs, 'createUserInput'>>;
  deleteDefinition?: Resolver<Maybe<ResolversTypes['DeleteDefinitionMutation']>, ParentType, ContextType, RequireFields<MutationDeleteDefinitionArgs, 'definitionId'>>;
  deleteEmailDraft?: Resolver<Maybe<ResolversTypes['MutationResult']>, ParentType, ContextType, RequireFields<MutationDeleteEmailDraftArgs, 'instructor' | 'teamId'>>;
  deleteExercise?: Resolver<Maybe<ResolversTypes['DeleteExerciseMutation']>, ParentType, ContextType, RequireFields<MutationDeleteExerciseArgs, 'exerciseId'>>;
  deleteTags?: Resolver<Maybe<ResolversTypes['DeleteTagsMutation']>, ParentType, ContextType, RequireFields<MutationDeleteTagsArgs, 'force' | 'tagIds'>>;
  deleteUsers?: Resolver<Maybe<ResolversTypes['DeleteUsersMutation']>, ParentType, ContextType, RequireFields<MutationDeleteUsersArgs, 'userIds'>>;
  login?: Resolver<Maybe<ResolversTypes['LoginMutation']>, ParentType, ContextType, RequireFields<MutationLoginArgs, 'password' | 'username'>>;
  logout?: Resolver<Maybe<ResolversTypes['LogoutMutation']>, ParentType, ContextType>;
  modifyMilestone?: Resolver<Maybe<ResolversTypes['ModifyMilestoneMutation']>, ParentType, ContextType, RequireFields<MutationModifyMilestoneArgs, 'activate' | 'milestone' | 'teamId'>>;
  moveTime?: Resolver<Maybe<ResolversTypes['MoveExerciseTimeMutation']>, ParentType, ContextType, RequireFields<MutationMoveTimeArgs, 'exerciseId' | 'timeDiff'>>;
  passwordChange?: Resolver<Maybe<ResolversTypes['PasswordChange']>, ParentType, ContextType, RequireFields<MutationPasswordChangeArgs, 'newPassword' | 'newPasswordRepeat' | 'oldPassword'>>;
  regenerateCredentials?: Resolver<Maybe<ResolversTypes['RegenerateCredentialsMutation']>, ParentType, ContextType, RequireFields<MutationRegenerateCredentialsArgs, 'userIds'>>;
  removeDefinitionAccess?: Resolver<Maybe<ResolversTypes['RemoveDefinitionAccessMutation']>, ParentType, ContextType, RequireFields<MutationRemoveDefinitionAccessArgs, 'definitionId' | 'userIds'>>;
  removeInstructorsFromExercise?: Resolver<Maybe<ResolversTypes['RemoveInstructorsFromExerciseMutation']>, ParentType, ContextType, RequireFields<MutationRemoveInstructorsFromExerciseArgs, 'exerciseId' | 'userIds'>>;
  removeUsersFromTeam?: Resolver<Maybe<ResolversTypes['RemoveUsersFromTeamMutation']>, ParentType, ContextType, RequireFields<MutationRemoveUsersFromTeamArgs, 'teamId' | 'userIds'>>;
  sendCustomInject?: Resolver<Maybe<ResolversTypes['SendCustomInjectMutation']>, ParentType, ContextType, RequireFields<MutationSendCustomInjectArgs, 'customInjectInput'>>;
  sendEmail?: Resolver<Maybe<ResolversTypes['SendEmailMutation']>, ParentType, ContextType, RequireFields<MutationSendEmailArgs, 'sendEmailInput'>>;
  setEmailDraft?: Resolver<Maybe<ResolversTypes['EmailDraftType']>, ParentType, ContextType, RequireFields<MutationSetEmailDraftArgs, 'emailDraft'>>;
  setIsUnreadChannel?: Resolver<Maybe<ResolversTypes['MutationResult']>, ParentType, ContextType, RequireFields<MutationSetIsUnreadChannelArgs, 'channelId' | 'isUnread' | 'teamId'>>;
  setIsUnreadEmailThread?: Resolver<Maybe<ResolversTypes['MutationResult']>, ParentType, ContextType, RequireFields<MutationSetIsUnreadEmailThreadArgs, 'isUnread' | 'teamId' | 'threadId'>>;
  startExercise?: Resolver<Maybe<ResolversTypes['StartExerciseMutation']>, ParentType, ContextType, RequireFields<MutationStartExerciseArgs, 'exerciseId'>>;
  stopExercise?: Resolver<Maybe<ResolversTypes['StopExerciseMutation']>, ParentType, ContextType, RequireFields<MutationStopExerciseArgs, 'exerciseId'>>;
  updateTag?: Resolver<Maybe<ResolversTypes['UpdateTagMutation']>, ParentType, ContextType, RequireFields<MutationUpdateTagArgs, 'newName' | 'tagId'>>;
  updateTagAssignments?: Resolver<Maybe<ResolversTypes['UpdateTagAssignmentsMutation']>, ParentType, ContextType, RequireFields<MutationUpdateTagAssignmentsArgs, 'updateTagAssignmentsInput'>>;
  useTool?: Resolver<Maybe<ResolversTypes['UseToolMutation']>, ParentType, ContextType, RequireFields<MutationUseToolArgs, 'useToolInput'>>;
  writeReadReceipt?: Resolver<Maybe<ResolversTypes['ReadReceiptType']>, ParentType, ContextType, RequireFields<MutationWriteReadReceiptArgs, 'actionLogId'>>;
  writeReadReceiptEmail?: Resolver<Maybe<ResolversTypes['EmailReceipt']>, ParentType, ContextType, RequireFields<MutationWriteReadReceiptEmailArgs, 'emailId'>>;
}>;

export type MutationResultResolvers<ContextType = any, ParentType extends ResolversParentTypes['MutationResult'] = ResolversParentTypes['MutationResult']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type OverlayTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['OverlayType'] = ResolversParentTypes['OverlayType']> = ResolversObject<{
  duration?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type PasswordChangeResolvers<ContextType = any, ParentType extends ResolversParentTypes['PasswordChange'] = ResolversParentTypes['PasswordChange']> = ResolversObject<{
  passwordChanged?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type QueryResolvers<ContextType = any, ParentType extends ResolversParentTypes['Query'] = ResolversParentTypes['Query']> = ResolversObject<{
  actionLog?: Resolver<Maybe<ResolversTypes['ActionLogType']>, ParentType, ContextType, RequireFields<QueryActionLogArgs, 'logId'>>;
  analyticsActionLogs?: Resolver<Maybe<Array<Maybe<ResolversTypes['ActionLogType']>>>, ParentType, ContextType, RequireFields<QueryAnalyticsActionLogsArgs, 'exerciseId'>>;
  analyticsEmailThreads?: Resolver<Maybe<Array<Maybe<ResolversTypes['EmailThreadType']>>>, ParentType, ContextType, RequireFields<QueryAnalyticsEmailThreadsArgs, 'exerciseId'>>;
  analyticsMilestones?: Resolver<Maybe<Array<Maybe<ResolversTypes['MilestoneStateType']>>>, ParentType, ContextType, RequireFields<QueryAnalyticsMilestonesArgs, 'exerciseId'>>;
  channel?: Resolver<Maybe<ResolversTypes['DefinitionChannelType']>, ParentType, ContextType, RequireFields<QueryChannelArgs, 'channelId'>>;
  definition?: Resolver<Maybe<ResolversTypes['DefinitionType']>, ParentType, ContextType, RequireFields<QueryDefinitionArgs, 'definitionId'>>;
  definitions?: Resolver<Maybe<Array<Maybe<ResolversTypes['DefinitionType']>>>, ParentType, ContextType>;
  emailAddresses?: Resolver<Maybe<Array<Maybe<ResolversTypes['String']>>>, ParentType, ContextType, RequireFields<QueryEmailAddressesArgs, 'threadId'>>;
  emailContact?: Resolver<Maybe<ResolversTypes['EmailParticipantType']>, ParentType, ContextType, RequireFields<QueryEmailContactArgs, 'participantId'>>;
  emailContacts?: Resolver<Maybe<Array<Maybe<ResolversTypes['EmailParticipantType']>>>, ParentType, ContextType, Partial<QueryEmailContactsArgs>>;
  emailTemplates?: Resolver<Maybe<Array<Maybe<ResolversTypes['EmailTemplateType']>>>, ParentType, ContextType, RequireFields<QueryEmailTemplatesArgs, 'emailAddresses' | 'exerciseId'>>;
  emailThread?: Resolver<Maybe<ResolversTypes['EmailThreadType']>, ParentType, ContextType, RequireFields<QueryEmailThreadArgs, 'threadId'>>;
  emailThreads?: Resolver<Maybe<Array<Maybe<ResolversTypes['EmailThreadType']>>>, ParentType, ContextType, RequireFields<QueryEmailThreadsArgs, 'teamId'>>;
  exerciseChannels?: Resolver<Maybe<Array<Maybe<ResolversTypes['DefinitionChannelType']>>>, ParentType, ContextType, RequireFields<QueryExerciseChannelsArgs, 'exerciseId'>>;
  exerciseConfig?: Resolver<Maybe<ResolversTypes['GrapheneConfig']>, ParentType, ContextType, RequireFields<QueryExerciseConfigArgs, 'exerciseId'>>;
  exerciseId?: Resolver<Maybe<ResolversTypes['ExerciseType']>, ParentType, ContextType, RequireFields<QueryExerciseIdArgs, 'exerciseId'>>;
  exerciseLoopRunning?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<QueryExerciseLoopRunningArgs, 'exerciseId'>>;
  exerciseQuestionnaires?: Resolver<Maybe<Array<Maybe<ResolversTypes['TeamQuestionnaireStateType']>>>, ParentType, ContextType, RequireFields<QueryExerciseQuestionnairesArgs, 'exerciseId'>>;
  exerciseTimeLeft?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  exerciseTools?: Resolver<Maybe<Array<Maybe<ResolversTypes['ToolType']>>>, ParentType, ContextType, RequireFields<QueryExerciseToolsArgs, 'exerciseId'>>;
  exercises?: Resolver<Maybe<Array<Maybe<ResolversTypes['ExerciseType']>>>, ParentType, ContextType, Partial<QueryExercisesArgs>>;
  extendedTeamTools?: Resolver<Maybe<Array<Maybe<ResolversTypes['ExtendedToolType']>>>, ParentType, ContextType, RequireFields<QueryExtendedTeamToolsArgs, 'teamId'>>;
  fileInfo?: Resolver<Maybe<ResolversTypes['FileInfoType']>, ParentType, ContextType, RequireFields<QueryFileInfoArgs, 'fileInfoId'>>;
  getEmailDraft?: Resolver<Maybe<ResolversTypes['EmailDraftType']>, ParentType, ContextType, RequireFields<QueryGetEmailDraftArgs, 'instructor' | 'teamId'>>;
  getEmailDrafts?: Resolver<Maybe<Array<Maybe<ResolversTypes['EmailDraftType']>>>, ParentType, ContextType, RequireFields<QueryGetEmailDraftsArgs, 'instructor' | 'teamId'>>;
  injects?: Resolver<Maybe<Array<Maybe<ResolversTypes['DefinitionInjectType']>>>, ParentType, ContextType, RequireFields<QueryInjectsArgs, 'exerciseId'>>;
  learningObjectives?: Resolver<Maybe<Array<Maybe<ResolversTypes['LearningObjectiveType']>>>, ParentType, ContextType, RequireFields<QueryLearningObjectivesArgs, 'exerciseId'>>;
  milestones?: Resolver<Maybe<Array<Maybe<ResolversTypes['MilestoneType']>>>, ParentType, ContextType, RequireFields<QueryMilestonesArgs, 'exerciseId'>>;
  questionnaireState?: Resolver<Maybe<ResolversTypes['TeamQuestionnaireStateType']>, ParentType, ContextType, RequireFields<QueryQuestionnaireStateArgs, 'questionnaireId' | 'teamId'>>;
  questionnaires?: Resolver<Maybe<Array<Maybe<ResolversTypes['QuestionnaireType']>>>, ParentType, ContextType, RequireFields<QueryQuestionnairesArgs, 'exerciseId'>>;
  tags?: Resolver<Maybe<Array<Maybe<ResolversTypes['TagType']>>>, ParentType, ContextType>;
  team?: Resolver<Maybe<ResolversTypes['TeamType']>, ParentType, ContextType, RequireFields<QueryTeamArgs, 'teamId'>>;
  teamActionLogs?: Resolver<Maybe<Array<Maybe<ResolversTypes['ActionLogType']>>>, ParentType, ContextType, RequireFields<QueryTeamActionLogsArgs, 'teamId'>>;
  teamChannelLogs?: Resolver<Maybe<Array<Maybe<ResolversTypes['ActionLogType']>>>, ParentType, ContextType, RequireFields<QueryTeamChannelLogsArgs, 'channelId' | 'teamId'>>;
  teamEmailParticipant?: Resolver<Maybe<ResolversTypes['EmailParticipantType']>, ParentType, ContextType, RequireFields<QueryTeamEmailParticipantArgs, 'teamId'>>;
  teamLearningObjectives?: Resolver<Maybe<Array<Maybe<ResolversTypes['TeamLearningObjectiveType']>>>, ParentType, ContextType, RequireFields<QueryTeamLearningObjectivesArgs, 'teamId'>>;
  teamMilestone?: Resolver<Maybe<ResolversTypes['MilestoneStateType']>, ParentType, ContextType, RequireFields<QueryTeamMilestoneArgs, 'milestoneStateId'>>;
  teamMilestones?: Resolver<Maybe<Array<Maybe<ResolversTypes['MilestoneStateType']>>>, ParentType, ContextType, RequireFields<QueryTeamMilestonesArgs, 'teamId'>>;
  teamQuestionnaires?: Resolver<Maybe<Array<Maybe<ResolversTypes['TeamQuestionnaireStateType']>>>, ParentType, ContextType, RequireFields<QueryTeamQuestionnairesArgs, 'teamId'>>;
  teamRoles?: Resolver<Maybe<Array<Maybe<ResolversTypes['String']>>>, ParentType, ContextType>;
  teamTools?: Resolver<Maybe<Array<Maybe<ResolversTypes['ToolType']>>>, ParentType, ContextType, RequireFields<QueryTeamToolsArgs, 'teamId'>>;
  teamUploadedFiles?: Resolver<Maybe<Array<Maybe<ResolversTypes['FileInfoType']>>>, ParentType, ContextType, RequireFields<QueryTeamUploadedFilesArgs, 'teamId'>>;
  threadTemplate?: Resolver<Maybe<ResolversTypes['EmailTemplateType']>, ParentType, ContextType, RequireFields<QueryThreadTemplateArgs, 'templateId'>>;
  threadTemplates?: Resolver<Maybe<Array<Maybe<ResolversTypes['EmailTemplateType']>>>, ParentType, ContextType, RequireFields<QueryThreadTemplatesArgs, 'threadId'>>;
  user?: Resolver<Maybe<ResolversTypes['UserType']>, ParentType, ContextType, Partial<QueryUserArgs>>;
  users?: Resolver<Maybe<Array<Maybe<ResolversTypes['UserType']>>>, ParentType, ContextType, Partial<QueryUsersArgs>>;
  validateEmailAddress?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<QueryValidateEmailAddressArgs, 'address' | 'exerciseId'>>;
  whoAmI?: Resolver<Maybe<ResolversTypes['UserType']>, ParentType, ContextType>;
}>;

export type QuestionTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['QuestionType'] = ResolversParentTypes['QuestionType']> = ResolversObject<{
  content?: Resolver<ResolversTypes['ContentType'], ParentType, ContextType>;
  control?: Resolver<ResolversTypes['ControlType'], ParentType, ContextType>;
  correct?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  labels?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  max?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  questionnaire?: Resolver<ResolversTypes['QuestionnaireType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type QuestionnaireAnswerTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['QuestionnaireAnswerType'] = ResolversParentTypes['QuestionnaireAnswerType']> = ResolversObject<{
  choice?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  isCorrect?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  question?: Resolver<ResolversTypes['QuestionType'], ParentType, ContextType>;
  teamQuestionnaireState?: Resolver<ResolversTypes['TeamQuestionnaireStateType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type QuestionnaireTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['QuestionnaireType'] = ResolversParentTypes['QuestionnaireType']> = ResolversObject<{
  control?: Resolver<ResolversTypes['ControlType'], ParentType, ContextType>;
  definition?: Resolver<ResolversTypes['DefinitionType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  overlay?: Resolver<Maybe<ResolversTypes['OverlayType']>, ParentType, ContextType>;
  questions?: Resolver<Array<ResolversTypes['QuestionType']>, ParentType, ContextType>;
  teamQuestionnaireStates?: Resolver<Array<ResolversTypes['TeamQuestionnaireStateType']>, ParentType, ContextType>;
  time?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  title?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ReadReceiptTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ReadReceiptType'] = ResolversParentTypes['ReadReceiptType']> = ResolversObject<{
  actionLogId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  readReceipt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type RegenerateCredentialsMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['RegenerateCredentialsMutation'] = ResolversParentTypes['RegenerateCredentialsMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type RemoveDefinitionAccessMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['RemoveDefinitionAccessMutation'] = ResolversParentTypes['RemoveDefinitionAccessMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type RemoveInstructorsFromExerciseMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['RemoveInstructorsFromExerciseMutation'] = ResolversParentTypes['RemoveInstructorsFromExerciseMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type RemoveUsersFromTeamMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['RemoveUsersFromTeamMutation'] = ResolversParentTypes['RemoveUsersFromTeamMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type RestrictedExerciseResolvers<ContextType = any, ParentType extends ResolversParentTypes['RestrictedExercise'] = ResolversParentTypes['RestrictedExercise']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  uuid?: Resolver<ResolversTypes['UUID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type RestrictedTeamResolvers<ContextType = any, ParentType extends ResolversParentTypes['RestrictedTeam'] = ResolversParentTypes['RestrictedTeam']> = ResolversObject<{
  emailAddress?: Resolver<Maybe<ResolversTypes['EmailParticipantType']>, ParentType, ContextType>;
  exercise?: Resolver<ResolversTypes['ExerciseType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  role?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type RestrictedUserResolvers<ContextType = any, ParentType extends ResolversParentTypes['RestrictedUser'] = ResolversParentTypes['RestrictedUser']> = ResolversObject<{
  dateJoined?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  firstName?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  group?: Resolver<Maybe<ResolversTypes['AuthGroup']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['UUID'], ParentType, ContextType>;
  isActive?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  isImported?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  lastLogin?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  lastName?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  tags?: Resolver<Array<ResolversTypes['TagType']>, ParentType, ContextType>;
  username?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SendCustomInjectMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['SendCustomInjectMutation'] = ResolversParentTypes['SendCustomInjectMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SendEmailMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['SendEmailMutation'] = ResolversParentTypes['SendEmailMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SendEmailTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['SendEmailType'] = ResolversParentTypes['SendEmailType']> = ResolversObject<{
  activateMilestone?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  content?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  deactivateMilestone?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  fileId?: Resolver<Maybe<ResolversTypes['UUID']>, ParentType, ContextType>;
  senderAddress?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  threadId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type StartExerciseMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['StartExerciseMutation'] = ResolversParentTypes['StartExerciseMutation']> = ResolversObject<{
  exercise?: Resolver<Maybe<ResolversTypes['ExerciseType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type StopExerciseMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['StopExerciseMutation'] = ResolversParentTypes['StopExerciseMutation']> = ResolversObject<{
  exercise?: Resolver<Maybe<ResolversTypes['ExerciseType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SubscriptionResolvers<ContextType = any, ParentType extends ResolversParentTypes['Subscription'] = ResolversParentTypes['Subscription']> = ResolversObject<{
  actionLogs?: SubscriptionResolver<Maybe<ResolversTypes['ActionLogsSubscription']>, "actionLogs", ParentType, ContextType, Partial<SubscriptionActionLogsArgs>>;
  analyticsActionLogsSubscription?: SubscriptionResolver<Maybe<ResolversTypes['AnalyticsActionLogsSubscription']>, "analyticsActionLogsSubscription", ParentType, ContextType, Partial<SubscriptionAnalyticsActionLogsSubscriptionArgs>>;
  analyticsEmailThreadSubscription?: SubscriptionResolver<Maybe<ResolversTypes['AnalyticsEmailThreadSubscription']>, "analyticsEmailThreadSubscription", ParentType, ContextType, Partial<SubscriptionAnalyticsEmailThreadSubscriptionArgs>>;
  analyticsMilestonesSubscription?: SubscriptionResolver<Maybe<ResolversTypes['AnalyticsMilestonesSubscription']>, "analyticsMilestonesSubscription", ParentType, ContextType, Partial<SubscriptionAnalyticsMilestonesSubscriptionArgs>>;
  emailThreads?: SubscriptionResolver<Maybe<ResolversTypes['EmailThreadSubscription']>, "emailThreads", ParentType, ContextType, Partial<SubscriptionEmailThreadsArgs>>;
  exerciseLoopRunning?: SubscriptionResolver<Maybe<ResolversTypes['ExerciseLoopRunningSubscription']>, "exerciseLoopRunning", ParentType, ContextType, Partial<SubscriptionExerciseLoopRunningArgs>>;
  exercisesSubscription?: SubscriptionResolver<Maybe<ResolversTypes['ExercisesSubscription']>, "exercisesSubscription", ParentType, ContextType>;
  milestones?: SubscriptionResolver<Maybe<ResolversTypes['MilestonesSubscription']>, "milestones", ParentType, ContextType, RequireFields<SubscriptionMilestonesArgs, 'teamId'>>;
  teamQuestionnaireStateSubscription?: SubscriptionResolver<Maybe<ResolversTypes['TeamQuestionnaireStateSubscription']>, "teamQuestionnaireStateSubscription", ParentType, ContextType, RequireFields<SubscriptionTeamQuestionnaireStateSubscriptionArgs, 'teamId'>>;
}>;

export type TagTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['TagType'] = ResolversParentTypes['TagType']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type TeamLearningActivityTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['TeamLearningActivityType'] = ResolversParentTypes['TeamLearningActivityType']> = ResolversObject<{
  activity?: Resolver<ResolversTypes['LearningActivityType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  milestoneStates?: Resolver<Array<ResolversTypes['MilestoneStateType']>, ParentType, ContextType>;
  reached?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  teamObjective?: Resolver<ResolversTypes['TeamLearningObjectiveType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type TeamLearningObjectiveTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['TeamLearningObjectiveType'] = ResolversParentTypes['TeamLearningObjectiveType']> = ResolversObject<{
  activities?: Resolver<Array<ResolversTypes['TeamLearningActivityType']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  objective?: Resolver<ResolversTypes['LearningObjectiveType'], ParentType, ContextType>;
  reached?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type TeamQuestionnaireStateSubscriptionResolvers<ContextType = any, ParentType extends ResolversParentTypes['TeamQuestionnaireStateSubscription'] = ResolversParentTypes['TeamQuestionnaireStateSubscription']> = ResolversObject<{
  teamQuestionnaireState?: Resolver<ResolversTypes['TeamQuestionnaireStateType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type TeamQuestionnaireStateTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['TeamQuestionnaireStateType'] = ResolversParentTypes['TeamQuestionnaireStateType']> = ResolversObject<{
  answers?: Resolver<Array<ResolversTypes['QuestionnaireAnswerType']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  questionnaire?: Resolver<ResolversTypes['QuestionnaireType'], ParentType, ContextType>;
  status?: Resolver<Maybe<ResolversTypes['Status']>, ParentType, ContextType>;
  team?: Resolver<ResolversTypes['TeamType'], ParentType, ContextType>;
  timestampAnswered?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  timestampSent?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type TeamTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['TeamType'] = ResolversParentTypes['TeamType']> = ResolversObject<{
  emailAddress?: Resolver<Maybe<ResolversTypes['EmailParticipantType']>, ParentType, ContextType>;
  exercise?: Resolver<ResolversTypes['ExerciseType'], ParentType, ContextType>;
  finishTime?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  logs?: Resolver<Array<ResolversTypes['ActionLogType']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  role?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  teamQuestionnaireStates?: Resolver<Array<ResolversTypes['TeamQuestionnaireStateType']>, ParentType, ContextType>;
  userSet?: Resolver<Maybe<Array<Maybe<ResolversTypes['RestrictedUser']>>>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ToolDetailsTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ToolDetailsType'] = ResolversParentTypes['ToolDetailsType']> = ResolversObject<{
  argument?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  content?: Resolver<ResolversTypes['ContentType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  tool?: Resolver<ResolversTypes['ToolType'], ParentType, ContextType>;
  user?: Resolver<Maybe<ResolversTypes['RestrictedUser']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ToolResponseTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ToolResponseType'] = ResolversParentTypes['ToolResponseType']> = ResolversObject<{
  content?: Resolver<ResolversTypes['ContentType'], ParentType, ContextType>;
  control?: Resolver<ResolversTypes['ControlType'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  param?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  regex?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  time?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  tool?: Resolver<ResolversTypes['ExtendedToolType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ToolTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['ToolType'] = ResolversParentTypes['ToolType']> = ResolversObject<{
  defaultResponse?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  definition?: Resolver<Maybe<ResolversTypes['ExerciseDefinitionType']>, ParentType, ContextType>;
  hint?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  roles?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  tooltipDescription?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export interface UuidScalarConfig extends GraphQLScalarTypeConfig<ResolversTypes['UUID'], any> {
  name: 'UUID';
}

export type UpdateTagAssignmentsMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['UpdateTagAssignmentsMutation'] = ResolversParentTypes['UpdateTagAssignmentsMutation']> = ResolversObject<{
  operationDone?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type UpdateTagAssignmentsTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['UpdateTagAssignmentsType'] = ResolversParentTypes['UpdateTagAssignmentsType']> = ResolversObject<{
  addTags?: Resolver<Array<ResolversTypes['ID']>, ParentType, ContextType>;
  removeTags?: Resolver<Array<ResolversTypes['ID']>, ParentType, ContextType>;
  userIds?: Resolver<Array<ResolversTypes['ID']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type UpdateTagMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['UpdateTagMutation'] = ResolversParentTypes['UpdateTagMutation']> = ResolversObject<{
  updatedTag?: Resolver<ResolversTypes['TagType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type UseToolMutationResolvers<ContextType = any, ParentType extends ResolversParentTypes['UseToolMutation'] = ResolversParentTypes['UseToolMutation']> = ResolversObject<{
  operationDone?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type UseToolTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['UseToolType'] = ResolversParentTypes['UseToolType']> = ResolversObject<{
  teamId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  toolArgument?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  toolId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type UserTypeResolvers<ContextType = any, ParentType extends ResolversParentTypes['UserType'] = ResolversParentTypes['UserType']> = ResolversObject<{
  dateJoined?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  definitions?: Resolver<Maybe<Array<Maybe<ResolversTypes['ExerciseDefinitionType']>>>, ParentType, ContextType>;
  exercises?: Resolver<Maybe<Array<Maybe<ResolversTypes['RestrictedExercise']>>>, ParentType, ContextType>;
  firstName?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  group?: Resolver<Maybe<ResolversTypes['AuthGroup']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['UUID'], ParentType, ContextType>;
  isActive?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  isImported?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  lastLogin?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  lastName?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  tags?: Resolver<Array<ResolversTypes['TagType']>, ParentType, ContextType>;
  teams?: Resolver<Maybe<Array<Maybe<ResolversTypes['RestrictedTeam']>>>, ParentType, ContextType>;
  username?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type Resolvers<ContextType = any> = ResolversObject<{
  ActionLogDetails?: ActionLogDetailsResolvers<ContextType>;
  ActionLogType?: ActionLogTypeResolvers<ContextType>;
  ActionLogsSubscription?: ActionLogsSubscriptionResolvers<ContextType>;
  AddDefinitionAccessMutation?: AddDefinitionAccessMutationResolvers<ContextType>;
  AnalyticsActionLogsSubscription?: AnalyticsActionLogsSubscriptionResolvers<ContextType>;
  AnalyticsEmailThreadSubscription?: AnalyticsEmailThreadSubscriptionResolvers<ContextType>;
  AnalyticsMilestonesSubscription?: AnalyticsMilestonesSubscriptionResolvers<ContextType>;
  AnswerQuestionnaireMutation?: AnswerQuestionnaireMutationResolvers<ContextType>;
  AssignInstructorsToExercise?: AssignInstructorsToExerciseResolvers<ContextType>;
  AssignUsersByTags?: AssignUsersByTagsResolvers<ContextType>;
  AssignUsersEqually?: AssignUsersEquallyResolvers<ContextType>;
  AssignUsersToTeamMutation?: AssignUsersToTeamMutationResolvers<ContextType>;
  ChangeUserDataMutation?: ChangeUserDataMutationResolvers<ContextType>;
  ChangeUserType?: ChangeUserTypeResolvers<ContextType>;
  ChannelReceipt?: ChannelReceiptResolvers<ContextType>;
  ConfigOverrideType?: ConfigOverrideTypeResolvers<ContextType>;
  ContentType?: ContentTypeResolvers<ContextType>;
  ControlType?: ControlTypeResolvers<ContextType>;
  CopyUsersAssignment?: CopyUsersAssignmentResolvers<ContextType>;
  CreateExerciseMutation?: CreateExerciseMutationResolvers<ContextType>;
  CreateExerciseType?: CreateExerciseTypeResolvers<ContextType>;
  CreateTagMutation?: CreateTagMutationResolvers<ContextType>;
  CreateThreadMutation?: CreateThreadMutationResolvers<ContextType>;
  CreateUserMutation?: CreateUserMutationResolvers<ContextType>;
  CreateUserType?: CreateUserTypeResolvers<ContextType>;
  CustomInjectDetailsType?: CustomInjectDetailsTypeResolvers<ContextType>;
  CustomInjectType?: CustomInjectTypeResolvers<ContextType>;
  DateTime?: GraphQLScalarType;
  DefinitionChannelType?: DefinitionChannelTypeResolvers<ContextType>;
  DefinitionInjectType?: DefinitionInjectTypeResolvers<ContextType>;
  DefinitionRoleType?: DefinitionRoleTypeResolvers<ContextType>;
  DefinitionType?: DefinitionTypeResolvers<ContextType>;
  DeleteDefinitionMutation?: DeleteDefinitionMutationResolvers<ContextType>;
  DeleteExerciseMutation?: DeleteExerciseMutationResolvers<ContextType>;
  DeleteTagsMutation?: DeleteTagsMutationResolvers<ContextType>;
  DeleteUsersMutation?: DeleteUsersMutationResolvers<ContextType>;
  EmailAddressType?: EmailAddressTypeResolvers<ContextType>;
  EmailDraftType?: EmailDraftTypeResolvers<ContextType>;
  EmailParticipantType?: EmailParticipantTypeResolvers<ContextType>;
  EmailReceipt?: EmailReceiptResolvers<ContextType>;
  EmailTemplateType?: EmailTemplateTypeResolvers<ContextType>;
  EmailThreadSubscription?: EmailThreadSubscriptionResolvers<ContextType>;
  EmailThreadType?: EmailThreadTypeResolvers<ContextType>;
  EmailType?: EmailTypeResolvers<ContextType>;
  ExerciseDefinitionType?: ExerciseDefinitionTypeResolvers<ContextType>;
  ExerciseLoopRunningSubscription?: ExerciseLoopRunningSubscriptionResolvers<ContextType>;
  ExerciseType?: ExerciseTypeResolvers<ContextType>;
  ExercisesSubscription?: ExercisesSubscriptionResolvers<ContextType>;
  ExtendedToolType?: ExtendedToolTypeResolvers<ContextType>;
  FileInfoType?: FileInfoTypeResolvers<ContextType>;
  FilterUsersType?: FilterUsersTypeResolvers<ContextType>;
  GrapheneConfig?: GrapheneConfigResolvers<ContextType>;
  InjectDetailsType?: InjectDetailsTypeResolvers<ContextType>;
  IsUnreadType?: IsUnreadTypeResolvers<ContextType>;
  LearningActivityType?: LearningActivityTypeResolvers<ContextType>;
  LearningObjectiveType?: LearningObjectiveTypeResolvers<ContextType>;
  LoginMutation?: LoginMutationResolvers<ContextType>;
  LogoutMutation?: LogoutMutationResolvers<ContextType>;
  MilestoneStateType?: MilestoneStateTypeResolvers<ContextType>;
  MilestoneType?: MilestoneTypeResolvers<ContextType>;
  MilestonesSubscription?: MilestonesSubscriptionResolvers<ContextType>;
  ModifyMilestoneMutation?: ModifyMilestoneMutationResolvers<ContextType>;
  MoveExerciseTimeMutation?: MoveExerciseTimeMutationResolvers<ContextType>;
  Mutation?: MutationResolvers<ContextType>;
  MutationResult?: MutationResultResolvers<ContextType>;
  OverlayType?: OverlayTypeResolvers<ContextType>;
  PasswordChange?: PasswordChangeResolvers<ContextType>;
  Query?: QueryResolvers<ContextType>;
  QuestionType?: QuestionTypeResolvers<ContextType>;
  QuestionnaireAnswerType?: QuestionnaireAnswerTypeResolvers<ContextType>;
  QuestionnaireType?: QuestionnaireTypeResolvers<ContextType>;
  ReadReceiptType?: ReadReceiptTypeResolvers<ContextType>;
  RegenerateCredentialsMutation?: RegenerateCredentialsMutationResolvers<ContextType>;
  RemoveDefinitionAccessMutation?: RemoveDefinitionAccessMutationResolvers<ContextType>;
  RemoveInstructorsFromExerciseMutation?: RemoveInstructorsFromExerciseMutationResolvers<ContextType>;
  RemoveUsersFromTeamMutation?: RemoveUsersFromTeamMutationResolvers<ContextType>;
  RestrictedExercise?: RestrictedExerciseResolvers<ContextType>;
  RestrictedTeam?: RestrictedTeamResolvers<ContextType>;
  RestrictedUser?: RestrictedUserResolvers<ContextType>;
  SendCustomInjectMutation?: SendCustomInjectMutationResolvers<ContextType>;
  SendEmailMutation?: SendEmailMutationResolvers<ContextType>;
  SendEmailType?: SendEmailTypeResolvers<ContextType>;
  StartExerciseMutation?: StartExerciseMutationResolvers<ContextType>;
  StopExerciseMutation?: StopExerciseMutationResolvers<ContextType>;
  Subscription?: SubscriptionResolvers<ContextType>;
  TagType?: TagTypeResolvers<ContextType>;
  TeamLearningActivityType?: TeamLearningActivityTypeResolvers<ContextType>;
  TeamLearningObjectiveType?: TeamLearningObjectiveTypeResolvers<ContextType>;
  TeamQuestionnaireStateSubscription?: TeamQuestionnaireStateSubscriptionResolvers<ContextType>;
  TeamQuestionnaireStateType?: TeamQuestionnaireStateTypeResolvers<ContextType>;
  TeamType?: TeamTypeResolvers<ContextType>;
  ToolDetailsType?: ToolDetailsTypeResolvers<ContextType>;
  ToolResponseType?: ToolResponseTypeResolvers<ContextType>;
  ToolType?: ToolTypeResolvers<ContextType>;
  UUID?: GraphQLScalarType;
  UpdateTagAssignmentsMutation?: UpdateTagAssignmentsMutationResolvers<ContextType>;
  UpdateTagAssignmentsType?: UpdateTagAssignmentsTypeResolvers<ContextType>;
  UpdateTagMutation?: UpdateTagMutationResolvers<ContextType>;
  UseToolMutation?: UseToolMutationResolvers<ContextType>;
  UseToolType?: UseToolTypeResolvers<ContextType>;
  UserType?: UserTypeResolvers<ContextType>;
}>;

