/* eslint-disable */
//@ts-nocheck
import type * as _Types from '../types';

import type { DocumentNode } from 'graphql';
import * as Apollo from '@apollo/client';
const defaultOptions = {} as const;
export type ExercisesVariables = _Types.Exact<{ [key: string]: never; }>;


export type Exercises = { exercisesSubscription: { eventType: _Types.ExerciseEventTypeEnum | null, exercise: { id: string, name: string, running: boolean, finished: boolean, exerciseStart: string | null, timeDelta: number, definition: { id: number | null, name: string | null } | null, teams: Array<{ id: string, name: string, role: string, emailAddress: { id: string, address: string, definitionAddress: { id: string, address: string, description: string, teamVisible: boolean, organization: string, control: { id: string, milestoneCondition: string, activateMilestone: string, deactivateMilestone: string, roles: string } } | null, team: { id: string, name: string, role: string } | null } | null, exercise: { id: string, name: string }, userSet: Array<{ id: any, username: string, firstName: string | null, lastName: string | null, group: _Types.AuthGroup | null } | null> | null }>, emailParticipants: Array<{ id: string, address: string, definitionAddress: { id: string, address: string, description: string, teamVisible: boolean, organization: string, control: { id: string, milestoneCondition: string, activateMilestone: string, deactivateMilestone: string, roles: string } } | null, team: { id: string, name: string, role: string } | null }>, userSet: Array<{ id: any, username: string, firstName: string | null, lastName: string | null, group: _Types.AuthGroup | null } | null> | null } | null } | null };


export const ExercisesDocument = /*#__PURE__*/ {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"exercises"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exercisesSubscription"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exercise"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Exercise"}}]}},{"kind":"Field","name":{"kind":"Name","value":"eventType"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Exercise"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ExerciseType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"running"}},{"kind":"Field","name":{"kind":"Name","value":"finished"}},{"kind":"Field","name":{"kind":"Name","value":"exerciseStart"}},{"kind":"Field","name":{"kind":"Name","value":"definition"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ExerciseDefinition"}}]}},{"kind":"Field","name":{"kind":"Name","value":"teams"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Team"}}]}},{"kind":"Field","name":{"kind":"Name","value":"emailParticipants"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailParticipant"}}]}},{"kind":"Field","alias":{"kind":"Name","value":"timeDelta"},"name":{"kind":"Name","value":"elapsedS"}},{"kind":"Field","name":{"kind":"Name","value":"definition"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"userSet"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"RestrictedUser"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ExerciseDefinition"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ExerciseDefinitionType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Team"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"TeamType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"role"}},{"kind":"Field","name":{"kind":"Name","value":"emailAddress"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailParticipant"}}]}},{"kind":"Field","name":{"kind":"Name","value":"exercise"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"userSet"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"RestrictedUser"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailParticipant"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailParticipantType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"definitionAddress"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailAddress"}}]}},{"kind":"Field","name":{"kind":"Name","value":"address"}},{"kind":"Field","name":{"kind":"Name","value":"team"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"TeamWithoutEmailAddress"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailAddress"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailAddressType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"address"}},{"kind":"Field","name":{"kind":"Name","value":"description"}},{"kind":"Field","name":{"kind":"Name","value":"control"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Control"}}]}},{"kind":"Field","name":{"kind":"Name","value":"teamVisible"}},{"kind":"Field","name":{"kind":"Name","value":"organization"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Control"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ControlType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"milestoneCondition"}},{"kind":"Field","name":{"kind":"Name","value":"activateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"deactivateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"roles"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"TeamWithoutEmailAddress"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"TeamType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"role"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"RestrictedUser"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"RestrictedUser"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"username"}},{"kind":"Field","name":{"kind":"Name","value":"firstName"}},{"kind":"Field","name":{"kind":"Name","value":"lastName"}},{"kind":"Field","name":{"kind":"Name","value":"group"}}]}}]} as unknown as DocumentNode;

/**
 * __useExercises__
 *
 * To run a query within a React component, call `useExercises` and pass it any options that fit your needs.
 * When your component renders, `useExercises` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the subscription, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useExercises({
 *   variables: {
 *   },
 * });
 */
export function useExercises(baseOptions?: Apollo.SubscriptionHookOptions<Exercises, ExercisesVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useSubscription<Exercises, ExercisesVariables>(ExercisesDocument, options);
      }
export type ExercisesHookResult = ReturnType<typeof useExercises>;
export type ExercisesSubscriptionResult = Apollo.SubscriptionResult<Exercises>;