/* eslint-disable */
//@ts-nocheck
import type * as _Types from '../../types';

import type { DocumentNode } from 'graphql';
import * as Apollo from '@apollo/client';
const defaultOptions = {} as const;
export type GetEmailDraftVariables = _Types.Exact<{
  teamId: _Types.Scalars['ID']['input'];
  instructor: _Types.Scalars['Boolean']['input'];
  emailThreadId: _Types.InputMaybe<_Types.Scalars['ID']['input']>;
}>;


export type GetEmailDraft = { getEmailDraft: { teamId: string, instructor: boolean, emailThreadId: string | null, senderAddress: string | null, content: string | null, activateMilestone: string | null, deactivateMilestone: string | null, fileId: any | null, selectedContacts: Array<string | null> | null, subject: string | null, templateId: string | null } | null };


export const GetEmailDraftDocument = /*#__PURE__*/ {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"GetEmailDraft"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"teamId"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"ID"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"instructor"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"Boolean"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"emailThreadId"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"ID"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"getEmailDraft"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"teamId"},"value":{"kind":"Variable","name":{"kind":"Name","value":"teamId"}}},{"kind":"Argument","name":{"kind":"Name","value":"instructor"},"value":{"kind":"Variable","name":{"kind":"Name","value":"instructor"}}},{"kind":"Argument","name":{"kind":"Name","value":"emailThreadId"},"value":{"kind":"Variable","name":{"kind":"Name","value":"emailThreadId"}}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"client"}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailDraft"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailDraft"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailDraftType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"teamId"}},{"kind":"Field","name":{"kind":"Name","value":"instructor"}},{"kind":"Field","name":{"kind":"Name","value":"emailThreadId"}},{"kind":"Field","name":{"kind":"Name","value":"senderAddress"}},{"kind":"Field","name":{"kind":"Name","value":"content"}},{"kind":"Field","name":{"kind":"Name","value":"activateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"deactivateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"fileId"}},{"kind":"Field","name":{"kind":"Name","value":"selectedContacts"}},{"kind":"Field","name":{"kind":"Name","value":"subject"}},{"kind":"Field","name":{"kind":"Name","value":"templateId"}}]}}]} as unknown as DocumentNode;

/**
 * __useGetEmailDraft__
 *
 * To run a query within a React component, call `useGetEmailDraft` and pass it any options that fit your needs.
 * When your component renders, `useGetEmailDraft` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetEmailDraft({
 *   variables: {
 *      teamId: // value for 'teamId'
 *      instructor: // value for 'instructor'
 *      emailThreadId: // value for 'emailThreadId'
 *   },
 * });
 */
export function useGetEmailDraft(baseOptions: Apollo.QueryHookOptions<GetEmailDraft, GetEmailDraftVariables> & ({ variables: GetEmailDraftVariables; skip?: boolean; } | { skip: boolean; }) ) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GetEmailDraft, GetEmailDraftVariables>(GetEmailDraftDocument, options);
      }
export function useGetEmailDraftLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GetEmailDraft, GetEmailDraftVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GetEmailDraft, GetEmailDraftVariables>(GetEmailDraftDocument, options);
        }
export function useGetEmailDraftSuspenseQuery(baseOptions?: Apollo.SuspenseQueryHookOptions<GetEmailDraft, GetEmailDraftVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useSuspenseQuery<GetEmailDraft, GetEmailDraftVariables>(GetEmailDraftDocument, options);
        }
export type GetEmailDraftHookResult = ReturnType<typeof useGetEmailDraft>;
export type GetEmailDraftLazyQueryHookResult = ReturnType<typeof useGetEmailDraftLazyQuery>;
export type GetEmailDraftSuspenseQueryHookResult = ReturnType<typeof useGetEmailDraftSuspenseQuery>;
export type GetEmailDraftQueryResult = Apollo.QueryResult<GetEmailDraft, GetEmailDraftVariables>;