/* eslint-disable */
//@ts-nocheck
import type * as _Types from '../types';

import type { DocumentNode } from 'graphql';
import * as Apollo from '@apollo/client';
const defaultOptions = {} as const;
export type GetToolsVariables = _Types.Exact<{
  exerciseId: _Types.Scalars['ID']['input'];
}>;


export type GetTools = { exerciseTools: Array<{ id: string, name: string, tooltipDescription: string, defaultResponse: string, roles: string, hint: string, definition: { id: number | null, name: string | null } | null } | null> | null };


export const GetToolsDocument = /*#__PURE__*/ {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"GetTools"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"exerciseId"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"ID"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exerciseTools"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"exerciseId"},"value":{"kind":"Variable","name":{"kind":"Name","value":"exerciseId"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Tool"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Tool"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ToolType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"tooltipDescription"}},{"kind":"Field","name":{"kind":"Name","value":"defaultResponse"}},{"kind":"Field","name":{"kind":"Name","value":"roles"}},{"kind":"Field","name":{"kind":"Name","value":"hint"}},{"kind":"Field","name":{"kind":"Name","value":"definition"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ExerciseDefinition"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ExerciseDefinition"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ExerciseDefinitionType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}}]} as unknown as DocumentNode;

/**
 * __useGetTools__
 *
 * To run a query within a React component, call `useGetTools` and pass it any options that fit your needs.
 * When your component renders, `useGetTools` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetTools({
 *   variables: {
 *      exerciseId: // value for 'exerciseId'
 *   },
 * });
 */
export function useGetTools(baseOptions: Apollo.QueryHookOptions<GetTools, GetToolsVariables> & ({ variables: GetToolsVariables; skip?: boolean; } | { skip: boolean; }) ) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GetTools, GetToolsVariables>(GetToolsDocument, options);
      }
export function useGetToolsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GetTools, GetToolsVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GetTools, GetToolsVariables>(GetToolsDocument, options);
        }
export function useGetToolsSuspenseQuery(baseOptions?: Apollo.SuspenseQueryHookOptions<GetTools, GetToolsVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useSuspenseQuery<GetTools, GetToolsVariables>(GetToolsDocument, options);
        }
export type GetToolsHookResult = ReturnType<typeof useGetTools>;
export type GetToolsLazyQueryHookResult = ReturnType<typeof useGetToolsLazyQuery>;
export type GetToolsSuspenseQueryHookResult = ReturnType<typeof useGetToolsSuspenseQuery>;
export type GetToolsQueryResult = Apollo.QueryResult<GetTools, GetToolsVariables>;