/* eslint-disable */
//@ts-nocheck
import type * as _Types from '../types';

import type { DocumentNode } from 'graphql';
import * as Apollo from '@apollo/client';
const defaultOptions = {} as const;
export type GetTeamMilestonesVariables = _Types.Exact<{
  teamId: _Types.Scalars['ID']['input'];
}>;


export type GetTeamMilestones = { teamMilestones: Array<{ id: string, reached: boolean, timestampReached: string | null, teamIds: Array<string | null> | null, milestone: { id: string, name: string, teamVisible: boolean, roles: string, fileNames: string } } | null> | null };


export const GetTeamMilestonesDocument = /*#__PURE__*/ {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"GetTeamMilestones"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"teamId"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"ID"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"teamMilestones"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"teamId"},"value":{"kind":"Variable","name":{"kind":"Name","value":"teamId"}}},{"kind":"Argument","name":{"kind":"Name","value":"visibleOnly"},"value":{"kind":"BooleanValue","value":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"MilestoneState"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"MilestoneState"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"MilestoneStateType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"milestone"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Milestone"}}]}},{"kind":"Field","name":{"kind":"Name","value":"reached"}},{"kind":"Field","name":{"kind":"Name","value":"timestampReached"}},{"kind":"Field","name":{"kind":"Name","value":"teamIds"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Milestone"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"MilestoneType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"teamVisible"}},{"kind":"Field","name":{"kind":"Name","value":"roles"}},{"kind":"Field","name":{"kind":"Name","value":"fileNames"}}]}}]} as unknown as DocumentNode;

/**
 * __useGetTeamMilestones__
 *
 * To run a query within a React component, call `useGetTeamMilestones` and pass it any options that fit your needs.
 * When your component renders, `useGetTeamMilestones` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetTeamMilestones({
 *   variables: {
 *      teamId: // value for 'teamId'
 *   },
 * });
 */
export function useGetTeamMilestones(baseOptions: Apollo.QueryHookOptions<GetTeamMilestones, GetTeamMilestonesVariables> & ({ variables: GetTeamMilestonesVariables; skip?: boolean; } | { skip: boolean; }) ) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GetTeamMilestones, GetTeamMilestonesVariables>(GetTeamMilestonesDocument, options);
      }
export function useGetTeamMilestonesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GetTeamMilestones, GetTeamMilestonesVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GetTeamMilestones, GetTeamMilestonesVariables>(GetTeamMilestonesDocument, options);
        }
export function useGetTeamMilestonesSuspenseQuery(baseOptions?: Apollo.SuspenseQueryHookOptions<GetTeamMilestones, GetTeamMilestonesVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useSuspenseQuery<GetTeamMilestones, GetTeamMilestonesVariables>(GetTeamMilestonesDocument, options);
        }
export type GetTeamMilestonesHookResult = ReturnType<typeof useGetTeamMilestones>;
export type GetTeamMilestonesLazyQueryHookResult = ReturnType<typeof useGetTeamMilestonesLazyQuery>;
export type GetTeamMilestonesSuspenseQueryHookResult = ReturnType<typeof useGetTeamMilestonesSuspenseQuery>;
export type GetTeamMilestonesQueryResult = Apollo.QueryResult<GetTeamMilestones, GetTeamMilestonesVariables>;