/* eslint-disable */
//@ts-nocheck
import type * as _Types from '../types';

import type { DocumentNode } from 'graphql';
import * as Apollo from '@apollo/client';
const defaultOptions = {} as const;
export type GetExerciseConfigVariables = _Types.Exact<{
  exerciseId: _Types.Scalars['ID']['input'];
  teamId: _Types.Scalars['ID']['input'];
}>;


export type GetExerciseConfig = { exerciseConfig: { exerciseDuration: number | null, emailBetweenTeams: boolean | null, showExerciseTime: boolean | null, enableRoles: boolean | null, customEmailSuffix: string | null } | null, teamTools: Array<{ id: string, name: string, tooltipDescription: string, defaultResponse: string, roles: string, hint: string, definition: { id: number | null, name: string | null } | null } | null> | null };


export const GetExerciseConfigDocument = /*#__PURE__*/ {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"GetExerciseConfig"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"exerciseId"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"ID"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"teamId"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"ID"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exerciseConfig"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"exerciseId"},"value":{"kind":"Variable","name":{"kind":"Name","value":"exerciseId"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ExerciseConfig"}}]}},{"kind":"Field","name":{"kind":"Name","value":"teamTools"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"teamId"},"value":{"kind":"Variable","name":{"kind":"Name","value":"teamId"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Tool"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ExerciseConfig"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"GrapheneConfig"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exerciseDuration"}},{"kind":"Field","name":{"kind":"Name","value":"emailBetweenTeams"}},{"kind":"Field","name":{"kind":"Name","value":"showExerciseTime"}},{"kind":"Field","name":{"kind":"Name","value":"enableRoles"}},{"kind":"Field","name":{"kind":"Name","value":"customEmailSuffix"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Tool"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ToolType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"tooltipDescription"}},{"kind":"Field","name":{"kind":"Name","value":"defaultResponse"}},{"kind":"Field","name":{"kind":"Name","value":"roles"}},{"kind":"Field","name":{"kind":"Name","value":"hint"}},{"kind":"Field","name":{"kind":"Name","value":"definition"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ExerciseDefinition"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ExerciseDefinition"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ExerciseDefinitionType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}}]} as unknown as DocumentNode;

/**
 * __useGetExerciseConfig__
 *
 * To run a query within a React component, call `useGetExerciseConfig` and pass it any options that fit your needs.
 * When your component renders, `useGetExerciseConfig` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetExerciseConfig({
 *   variables: {
 *      exerciseId: // value for 'exerciseId'
 *      teamId: // value for 'teamId'
 *   },
 * });
 */
export function useGetExerciseConfig(baseOptions: Apollo.QueryHookOptions<GetExerciseConfig, GetExerciseConfigVariables> & ({ variables: GetExerciseConfigVariables; skip?: boolean; } | { skip: boolean; }) ) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GetExerciseConfig, GetExerciseConfigVariables>(GetExerciseConfigDocument, options);
      }
export function useGetExerciseConfigLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GetExerciseConfig, GetExerciseConfigVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GetExerciseConfig, GetExerciseConfigVariables>(GetExerciseConfigDocument, options);
        }
export function useGetExerciseConfigSuspenseQuery(baseOptions?: Apollo.SuspenseQueryHookOptions<GetExerciseConfig, GetExerciseConfigVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useSuspenseQuery<GetExerciseConfig, GetExerciseConfigVariables>(GetExerciseConfigDocument, options);
        }
export type GetExerciseConfigHookResult = ReturnType<typeof useGetExerciseConfig>;
export type GetExerciseConfigLazyQueryHookResult = ReturnType<typeof useGetExerciseConfigLazyQuery>;
export type GetExerciseConfigSuspenseQueryHookResult = ReturnType<typeof useGetExerciseConfigSuspenseQuery>;
export type GetExerciseConfigQueryResult = Apollo.QueryResult<GetExerciseConfig, GetExerciseConfigVariables>;