/* eslint-disable */
//@ts-nocheck
import type * as _Types from '../types';

import type { DocumentNode } from 'graphql';
import * as Apollo from '@apollo/client';
const defaultOptions = {} as const;
export type GetExerciseChannelsVariables = _Types.Exact<{
  exerciseId: _Types.Scalars['ID']['input'];
}>;


export type GetExerciseChannels = { exerciseChannels: Array<{ id: string, name: string, type: _Types.ChannelType, readReceipt: Array<{ isUnread: boolean | null, teamId: string }> } | null> | null };


export const GetExerciseChannelsDocument = /*#__PURE__*/ {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"GetExerciseChannels"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"exerciseId"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"ID"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exerciseChannels"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"exerciseId"},"value":{"kind":"Variable","name":{"kind":"Name","value":"exerciseId"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Channel"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Channel"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"DefinitionChannelType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"readReceipt"},"directives":[{"kind":"Directive","name":{"kind":"Name","value":"client"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"always"},"value":{"kind":"BooleanValue","value":true}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"isUnread"}},{"kind":"Field","name":{"kind":"Name","value":"teamId"}}]}}]}}]} as unknown as DocumentNode;

/**
 * __useGetExerciseChannels__
 *
 * To run a query within a React component, call `useGetExerciseChannels` and pass it any options that fit your needs.
 * When your component renders, `useGetExerciseChannels` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetExerciseChannels({
 *   variables: {
 *      exerciseId: // value for 'exerciseId'
 *   },
 * });
 */
export function useGetExerciseChannels(baseOptions: Apollo.QueryHookOptions<GetExerciseChannels, GetExerciseChannelsVariables> & ({ variables: GetExerciseChannelsVariables; skip?: boolean; } | { skip: boolean; }) ) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GetExerciseChannels, GetExerciseChannelsVariables>(GetExerciseChannelsDocument, options);
      }
export function useGetExerciseChannelsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GetExerciseChannels, GetExerciseChannelsVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GetExerciseChannels, GetExerciseChannelsVariables>(GetExerciseChannelsDocument, options);
        }
export function useGetExerciseChannelsSuspenseQuery(baseOptions?: Apollo.SuspenseQueryHookOptions<GetExerciseChannels, GetExerciseChannelsVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useSuspenseQuery<GetExerciseChannels, GetExerciseChannelsVariables>(GetExerciseChannelsDocument, options);
        }
export type GetExerciseChannelsHookResult = ReturnType<typeof useGetExerciseChannels>;
export type GetExerciseChannelsLazyQueryHookResult = ReturnType<typeof useGetExerciseChannelsLazyQuery>;
export type GetExerciseChannelsSuspenseQueryHookResult = ReturnType<typeof useGetExerciseChannelsSuspenseQuery>;
export type GetExerciseChannelsQueryResult = Apollo.QueryResult<GetExerciseChannels, GetExerciseChannelsVariables>;